/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.timeout;

import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.client.providers.netty.timeout.TimeoutTimerTask;
import com.ning.http.client.providers.netty.timeout.TimeoutsHolder;
import com.ning.http.util.DateUtils;
import org.jboss.netty.util.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadTimeoutTimerTask
extends TimeoutTimerTask {
    private final long readTimeout;
    private final long requestTimeoutInstant;

    public ReadTimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyAsyncHttpProvider provider, TimeoutsHolder timeoutsHolder, long requestTimeout, long readTimeout) {
        super(nettyResponseFuture, provider, timeoutsHolder);
        this.readTimeout = readTimeout;
        this.requestTimeoutInstant = requestTimeout >= 0L ? nettyResponseFuture.getStart() + requestTimeout : Long.MAX_VALUE;
    }

    public void run(Timeout timeout) throws Exception {
        if (this.provider.isClose() || this.nettyResponseFuture.isDone()) {
            this.timeoutsHolder.cancel();
            return;
        }
        long now = DateUtils.millisTime();
        long currentReadTimeoutInstant = this.readTimeout + this.nettyResponseFuture.getLastTouch();
        long durationBeforeCurrentReadTimeout = currentReadTimeoutInstant - now;
        if (durationBeforeCurrentReadTimeout <= 0L) {
            String message = "Read timeout to " + this.nettyResponseFuture.getChannelRemoteAddress() + " of " + this.readTimeout + " ms";
            long durationSinceLastTouch = now - this.nettyResponseFuture.getLastTouch();
            this.expire(message, durationSinceLastTouch);
        } else {
            this.timeoutsHolder.readTimeout = currentReadTimeoutInstant < this.requestTimeoutInstant ? this.provider.newTimeout(this, durationBeforeCurrentReadTimeout) : null;
        }
    }
}

