/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.ws;

import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.response.NettyResponseBodyPart;
import com.ning.http.client.providers.netty.util.ChannelBufferUtils;
import com.ning.http.client.websocket.WebSocket;
import com.ning.http.client.websocket.WebSocketByteFragmentListener;
import com.ning.http.client.websocket.WebSocketByteListener;
import com.ning.http.client.websocket.WebSocketCloseCodeReasonListener;
import com.ning.http.client.websocket.WebSocketListener;
import com.ning.http.client.websocket.WebSocketPingListener;
import com.ning.http.client.websocket.WebSocketPongListener;
import com.ning.http.client.websocket.WebSocketTextFragmentListener;
import com.ning.http.client.websocket.WebSocketTextListener;
import com.ning.http.util.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocket
implements WebSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyWebSocket.class);
    protected final Channel channel;
    protected final Collection<WebSocketListener> listeners;
    protected final int maxBufferSize;
    private int bufferSize;
    private List<ChannelBuffer> _fragments;
    private volatile boolean interestedInByteMessages;
    private volatile boolean interestedInTextMessages;

    public NettyWebSocket(Channel channel, NettyAsyncHttpProviderConfig nettyConfig) {
        this(channel, nettyConfig, new ConcurrentLinkedQueue<WebSocketListener>());
    }

    public NettyWebSocket(Channel channel, NettyAsyncHttpProviderConfig nettyConfig, Collection<WebSocketListener> listeners) {
        this.channel = channel;
        this.listeners = listeners;
        this.maxBufferSize = nettyConfig.getWebSocketMaxBufferSize();
    }

    @Override
    public WebSocket sendMessage(byte[] message) {
        this.channel.write((Object)new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])message)));
        return this;
    }

    @Override
    public WebSocket stream(byte[] fragment, boolean last) {
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])fragment));
        frame.setFinalFragment(last);
        this.channel.write((Object)frame);
        return this;
    }

    @Override
    public WebSocket stream(byte[] fragment, int offset, int len, boolean last) {
        BinaryWebSocketFrame frame = new BinaryWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])fragment, (int)offset, (int)len));
        frame.setFinalFragment(last);
        this.channel.write((Object)frame);
        return this;
    }

    @Override
    public WebSocket sendMessage(String message) {
        this.channel.write((Object)new TextWebSocketFrame(message));
        return this;
    }

    @Override
    public WebSocket stream(String fragment, boolean last) {
        TextWebSocketFrame frame = new TextWebSocketFrame(fragment);
        frame.setFinalFragment(last);
        this.channel.write((Object)frame);
        return this;
    }

    @Override
    public WebSocket sendPing(byte[] payload) {
        this.channel.write((Object)new PingWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)));
        return this;
    }

    @Override
    public WebSocket sendPong(byte[] payload) {
        this.channel.write((Object)new PongWebSocketFrame(ChannelBuffers.wrappedBuffer((byte[])payload)));
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() {
        if (this.channel.isOpen()) {
            this.onClose();
            this.listeners.clear();
            this.channel.write((Object)new CloseWebSocketFrame()).addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void close(int statusCode, String reason) {
        this.onClose(statusCode, reason);
        this.listeners.clear();
    }

    public void onError(Throwable t) {
        for (WebSocketListener listener : this.listeners) {
            try {
                listener.onError(t);
            }
            catch (Throwable t2) {
                LOGGER.error("", t2);
            }
        }
    }

    protected void onClose() {
        this.onClose(1000, "Normal closure; the connection successfully completed whatever purpose for which it was created.");
    }

    public void onClose(int code, String reason) {
        for (WebSocketListener l : this.listeners) {
            try {
                if (l instanceof WebSocketCloseCodeReasonListener) {
                    ((WebSocketCloseCodeReasonListener)WebSocketCloseCodeReasonListener.class.cast(l)).onClose(this, code, reason);
                }
                l.onClose(this);
            }
            catch (Throwable t) {
                l.onError(t);
            }
        }
    }

    public String toString() {
        return "NettyWebSocket{channel=" + this.channel + '}';
    }

    private boolean hasWebSocketByteListener() {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketByteListener)) continue;
            return true;
        }
        return false;
    }

    private boolean hasWebSocketTextListener() {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketTextListener)) continue;
            return true;
        }
        return false;
    }

    @Override
    public WebSocket addWebSocketListener(WebSocketListener l) {
        this.listeners.add(l);
        this.interestedInByteMessages = this.interestedInByteMessages || l instanceof WebSocketByteListener;
        this.interestedInTextMessages = this.interestedInTextMessages || l instanceof WebSocketTextListener;
        return this;
    }

    @Override
    public WebSocket removeWebSocketListener(WebSocketListener l) {
        this.listeners.remove(l);
        if (l instanceof WebSocketByteListener) {
            this.interestedInByteMessages = this.hasWebSocketByteListener();
        }
        if (l instanceof WebSocketTextListener) {
            this.interestedInTextMessages = this.hasWebSocketTextListener();
        }
        return this;
    }

    private List<ChannelBuffer> fragments() {
        if (this._fragments == null) {
            this._fragments = new ArrayList<ChannelBuffer>(2);
        }
        return this._fragments;
    }

    private void bufferFragment(ChannelBuffer buffer) {
        this.bufferSize += buffer.readableBytes();
        if (this.bufferSize > this.maxBufferSize) {
            this.onError(new Exception("Exceeded Netty Web Socket maximum buffer size of " + this.maxBufferSize));
            this.reset();
            this.close();
        } else {
            this.fragments().add(buffer);
        }
    }

    private void reset() {
        this.fragments().clear();
        this.bufferSize = 0;
    }

    private void notifyByteListeners(ChannelBuffer channelBuffer) {
        byte[] message = ChannelBufferUtils.channelBuffer2bytes(channelBuffer);
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketByteListener)) continue;
            ((WebSocketByteListener)WebSocketByteListener.class.cast(listener)).onMessage(message);
        }
    }

    private void notifyTextListeners(ChannelBuffer channelBuffer) {
        String message = channelBuffer.toString(StandardCharsets.UTF_8);
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketTextListener)) continue;
            ((WebSocketTextListener)WebSocketTextListener.class.cast(listener)).onMessage(message);
        }
    }

    public void onBinaryFragment(HttpResponseBodyPart part) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketByteFragmentListener)) continue;
            ((WebSocketByteFragmentListener)WebSocketByteFragmentListener.class.cast(listener)).onFragment(part);
        }
        if (this.interestedInByteMessages) {
            ChannelBuffer fragment = ((NettyResponseBodyPart)NettyResponseBodyPart.class.cast(part)).getChannelBuffer();
            if (part.isLast()) {
                if (this.bufferSize == 0) {
                    this.notifyByteListeners(fragment);
                } else {
                    this.bufferFragment(fragment);
                    this.notifyByteListeners(ChannelBuffers.wrappedBuffer((ChannelBuffer[])this.fragments().toArray(new ChannelBuffer[this.fragments().size()])));
                }
                this.reset();
            } else {
                this.bufferFragment(fragment);
            }
        }
    }

    public void onTextFragment(HttpResponseBodyPart part) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketTextFragmentListener)) continue;
            ((WebSocketTextFragmentListener)WebSocketTextFragmentListener.class.cast(listener)).onFragment(part);
        }
        if (this.interestedInTextMessages) {
            ChannelBuffer fragment = ((NettyResponseBodyPart)NettyResponseBodyPart.class.cast(part)).getChannelBuffer();
            if (part.isLast()) {
                if (this.bufferSize == 0) {
                    this.notifyTextListeners(fragment);
                } else {
                    this.bufferFragment(fragment);
                    this.notifyTextListeners(ChannelBuffers.wrappedBuffer((ChannelBuffer[])this.fragments().toArray(new ChannelBuffer[this.fragments().size()])));
                }
                this.reset();
            } else {
                this.bufferFragment(fragment);
            }
        }
    }

    public void onPing(HttpResponseBodyPart part) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketPingListener)) continue;
            ((WebSocketPingListener)WebSocketPingListener.class.cast(listener)).onPing(part.getBodyPartBytes());
        }
    }

    public void onPong(HttpResponseBodyPart part) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketPongListener)) continue;
            ((WebSocketPongListener)WebSocketPongListener.class.cast(listener)).onPong(part.getBodyPartBytes());
        }
    }
}

