/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Request;
import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.client.uri.UriComponents;
import com.ning.http.util.Base64;
import com.ning.http.util.ProxyUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NettyConnectListener<T>
implements ChannelFutureListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyConnectListener.class);
    private final AsyncHttpClientConfig config;
    private final NettyResponseFuture<T> future;
    private final HttpRequest nettyRequest;

    private NettyConnectListener(AsyncHttpClientConfig config, NettyResponseFuture<T> future) {
        this.config = config;
        this.future = future;
        this.nettyRequest = future.getNettyRequest();
    }

    public NettyResponseFuture<T> future() {
        return this.future;
    }

    public final void operationComplete(ChannelFuture f) throws Exception {
        if (f.isSuccess()) {
            Channel channel = f.getChannel();
            channel.getPipeline().getContext(NettyAsyncHttpProvider.class).setAttachment(this.future);
            final SslHandler sslHandler = (SslHandler)channel.getPipeline().get("sslHandler");
            final HostnameVerifier hostnameVerifier = this.config.getHostnameVerifier();
            if (hostnameVerifier != null && sslHandler != null) {
                final String host = this.future.getURI().getHost();
                sslHandler.handshake().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture handshakeFuture) throws Exception {
                        if (handshakeFuture.isSuccess()) {
                            Channel channel = handshakeFuture.getChannel();
                            SSLEngine engine = sslHandler.getEngine();
                            SSLSession session = engine.getSession();
                            LOGGER.debug("onFutureSuccess: session = {}, id = {}, isValid = {}, host = {}", new Object[]{session.toString(), Base64.encode(session.getId()), session.isValid(), host});
                            if (!hostnameVerifier.verify(host, session)) {
                                ConnectException exception = new ConnectException("HostnameVerifier exception");
                                NettyConnectListener.this.future.abort(exception);
                                throw exception;
                            }
                            NettyConnectListener.this.future.provider().writeRequest(channel, NettyConnectListener.this.config, NettyConnectListener.this.future);
                        }
                    }
                });
            } else {
                this.future.provider().writeRequest(f.getChannel(), this.config, this.future);
            }
        } else {
            Throwable cause = f.getCause();
            boolean canRetry = this.future.canRetry();
            LOGGER.debug("Trying to recover a dead cached channel {} with a retry value of {} ", (Object)f.getChannel(), (Object)canRetry);
            if (canRetry && cause != null && (NettyAsyncHttpProvider.abortOnDisconnectException(cause) || cause instanceof ClosedChannelException || this.future.getState() != NettyResponseFuture.STATE.NEW)) {
                LOGGER.debug("Retrying {} ", (Object)this.nettyRequest);
                if (this.future.provider().remotelyClosed(f.getChannel(), this.future)) {
                    return;
                }
            }
            LOGGER.debug("Failed to recover from exception: {} with channel {}", (Object)cause, (Object)f.getChannel());
            boolean printCause = f.getCause() != null && cause.getMessage() != null;
            ConnectException e = new ConnectException(printCause ? cause.getMessage() + " to " + this.future.getURI().toString() : this.future.getURI().toString());
            if (cause != null) {
                e.initCause(cause);
            }
            this.future.abort(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T> {
        private final AsyncHttpClientConfig config;
        private final Request request;
        private final AsyncHandler<T> asyncHandler;
        private NettyResponseFuture<T> future;
        private final NettyAsyncHttpProvider provider;
        private final ChannelBuffer buffer;

        public Builder(AsyncHttpClientConfig config, Request request, AsyncHandler<T> asyncHandler, NettyAsyncHttpProvider provider, ChannelBuffer buffer) {
            this.config = config;
            this.request = request;
            this.asyncHandler = asyncHandler;
            this.future = null;
            this.provider = provider;
            this.buffer = buffer;
        }

        public Builder(AsyncHttpClientConfig config, Request request, AsyncHandler<T> asyncHandler, NettyResponseFuture<T> future, NettyAsyncHttpProvider provider, ChannelBuffer buffer) {
            this.config = config;
            this.request = request;
            this.asyncHandler = asyncHandler;
            this.future = future;
            this.provider = provider;
            this.buffer = buffer;
        }

        public NettyConnectListener<T> build(UriComponents uri) throws IOException {
            ProxyServer proxyServer = ProxyUtils.getProxyServer(this.config, this.request);
            HttpRequest nettyRequest = NettyAsyncHttpProvider.buildRequest(this.config, this.request, uri, true, this.buffer, proxyServer);
            if (this.future == null) {
                this.future = NettyAsyncHttpProvider.newFuture(uri, this.request, this.asyncHandler, nettyRequest, this.config, this.provider, proxyServer);
            } else {
                this.future.setNettyRequest(nettyRequest);
                this.future.setRequest(this.request);
            }
            return new NettyConnectListener(this.config, this.future);
        }
    }
}

