/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.ProxyServerSelector;
import com.ning.http.client.Request;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyUtils {
    private static final Logger log = LoggerFactory.getLogger(ProxyUtils.class);
    private static final String PROPERTY_PREFIX = "com.ning.http.client.AsyncHttpClientConfig.proxy.";
    public static final String PROXY_HOST = "http.proxyHost";
    public static final String PROXY_PORT = "http.proxyPort";
    public static final String PROXY_PROTOCOL = "com.ning.http.client.AsyncHttpClientConfig.proxy.protocol";
    public static final String PROXY_NONPROXYHOSTS = "http.nonProxyHosts";
    public static final String PROXY_USER = "com.ning.http.client.AsyncHttpClientConfig.proxy.user";
    public static final String PROXY_PASSWORD = "com.ning.http.client.AsyncHttpClientConfig.proxy.password";

    public static ProxyServer getProxyServer(AsyncHttpClientConfig config, Request request) {
        ProxyServerSelector selector;
        ProxyServer proxyServer = request.getProxyServer();
        if (proxyServer == null && (selector = config.getProxyServerSelector()) != null) {
            proxyServer = selector.select(request.getOriginalURI());
        }
        return ProxyUtils.avoidProxy(proxyServer, request) ? null : proxyServer;
    }

    public static boolean avoidProxy(ProxyServer proxyServer, Request request) {
        return ProxyUtils.avoidProxy(proxyServer, AsyncHttpProviderUtils.getHost(request.getOriginalURI()));
    }

    public static boolean avoidProxy(ProxyServer proxyServer, String target) {
        if (proxyServer != null) {
            String targetHost = target.toLowerCase(Locale.ENGLISH);
            List<String> nonProxyHosts = proxyServer.getNonProxyHosts();
            if (nonProxyHosts != null) {
                for (String nonProxyHost : nonProxyHosts) {
                    if (nonProxyHost.startsWith("*") && nonProxyHost.length() > 1 && targetHost.endsWith(nonProxyHost.substring(1).toLowerCase(Locale.ENGLISH))) {
                        return true;
                    }
                    if (nonProxyHost.endsWith("*") && nonProxyHost.length() > 1 && targetHost.startsWith(nonProxyHost.substring(0, nonProxyHost.length() - 1).toLowerCase(Locale.ENGLISH))) {
                        return true;
                    }
                    if (!nonProxyHost.equalsIgnoreCase(targetHost)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static ProxyServerSelector createProxyServerSelector(Properties properties) {
        String host = properties.getProperty(PROXY_HOST);
        if (host != null) {
            ProxyServer.Protocol protocol;
            int port = Integer.valueOf(properties.getProperty(PROXY_PORT, "80"));
            try {
                protocol = ProxyServer.Protocol.valueOf(properties.getProperty(PROXY_PROTOCOL, "HTTP"));
            }
            catch (IllegalArgumentException e) {
                protocol = ProxyServer.Protocol.HTTP;
            }
            ProxyServer proxyServer = new ProxyServer(protocol, host, port, properties.getProperty(PROXY_USER), properties.getProperty(PROXY_PASSWORD));
            String nonProxyHosts = properties.getProperty(PROXY_NONPROXYHOSTS);
            if (nonProxyHosts != null) {
                for (String spec : nonProxyHosts.split("\\|")) {
                    proxyServer.addNonProxyHost(spec);
                }
            }
            return ProxyUtils.createProxyServerSelector(proxyServer);
        }
        return ProxyServerSelector.NO_PROXY_SELECTOR;
    }

    public static ProxyServerSelector getJdkDefaultProxyServerSelector() {
        return ProxyUtils.createProxyServerSelector(ProxySelector.getDefault());
    }

    public static ProxyServerSelector createProxyServerSelector(final ProxySelector proxySelector) {
        return new ProxyServerSelector(){

            public ProxyServer select(URI uri) {
                List<Proxy> proxies = proxySelector.select(uri);
                if (proxies != null) {
                    for (Proxy proxy : proxies) {
                        switch (proxy.type()) {
                            case HTTP: {
                                if (!(proxy.address() instanceof InetSocketAddress)) {
                                    log.warn("Don't know how to connect to address " + proxy.address());
                                } else {
                                    InetSocketAddress address = (InetSocketAddress)proxy.address();
                                    return new ProxyServer(ProxyServer.Protocol.HTTP, address.getHostName(), address.getPort());
                                }
                            }
                            case DIRECT: {
                                return null;
                            }
                        }
                        log.warn("ProxySelector returned proxy type that we don't know how to use: " + (Object)((Object)proxy.type()));
                    }
                }
                return null;
            }
        };
    }

    public static ProxyServerSelector createProxyServerSelector(final ProxyServer proxyServer) {
        return new ProxyServerSelector(){

            public ProxyServer select(URI uri) {
                return proxyServer;
            }
        };
    }
}

