/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ConnectionsPool;
import com.ning.http.util.DateUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.utils.DataStructures;
import org.glassfish.grizzly.utils.NullaryFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyConnectionsPool
implements ConnectionsPool<String, Connection> {
    private static final Logger LOG = LoggerFactory.getLogger(GrizzlyConnectionsPool.class);
    private final ConcurrentHashMap<String, DelayedExecutor.IdleConnectionQueue> connectionsPool = new ConcurrentHashMap();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicInteger totalCachedConnections = new AtomicInteger(0);
    private final boolean cacheSSLConnections;
    private final int maxConnectionsPerHost;
    private final int maxConnections;
    private final boolean unlimitedConnections;
    private final long timeout;
    private final long maxConnectionLifeTimeInMs;
    private final DelayedExecutor delayedExecutor;
    private final boolean ownsDelayedExecutor;
    private final CloseListener listener = new CloseListener<Connection, CloseType>(){

        public void onClosed(Connection connection, CloseType closeType) throws IOException {
            if (closeType == CloseType.REMOTELY && LOG.isInfoEnabled()) {
                LOG.info("Remote closed connection ({}).  Removing from cache", (Object)connection.toString());
            }
            GrizzlyConnectionsPool.this.removeAll(connection);
        }
    };

    public GrizzlyConnectionsPool(boolean cacheSSLConnections, int timeout, int maxConnectionLifeTimeInMs, int maxConnectionsPerHost, int maxConnections, DelayedExecutor delayedExecutor) {
        this.cacheSSLConnections = cacheSSLConnections;
        this.timeout = timeout;
        this.maxConnectionLifeTimeInMs = maxConnectionLifeTimeInMs;
        this.maxConnectionsPerHost = maxConnectionsPerHost;
        this.maxConnections = maxConnections;
        boolean bl = this.unlimitedConnections = maxConnections == -1;
        if (delayedExecutor != null) {
            this.delayedExecutor = delayedExecutor;
            this.ownsDelayedExecutor = false;
        } else {
            this.delayedExecutor = new DelayedExecutor(Executors.newSingleThreadExecutor(), this);
            this.ownsDelayedExecutor = true;
        }
        if (!this.delayedExecutor.isStarted) {
            this.delayedExecutor.start();
        }
    }

    public GrizzlyConnectionsPool(AsyncHttpClientConfig config) {
        this.cacheSSLConnections = config.isSslConnectionPoolEnabled();
        this.timeout = config.getIdleConnectionInPoolTimeoutInMs();
        this.maxConnectionLifeTimeInMs = config.getMaxConnectionLifeTimeInMs();
        this.maxConnectionsPerHost = config.getMaxConnectionPerHost();
        this.maxConnections = config.getMaxTotalConnections();
        this.unlimitedConnections = this.maxConnections == -1;
        this.delayedExecutor = new DelayedExecutor(Executors.newSingleThreadExecutor(), this);
        this.delayedExecutor.start();
        this.ownsDelayedExecutor = true;
    }

    @Override
    public boolean offer(String uri, Connection connection) {
        if (this.isSecure(uri) && !this.cacheSSLConnections) {
            return false;
        }
        DelayedExecutor.IdleConnectionQueue conQueue = this.connectionsPool.get(uri);
        if (conQueue == null) {
            DelayedExecutor.IdleConnectionQueue newPool;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating new Connection queue for uri [{}] and connection [{}]", new Object[]{uri, connection});
            }
            if ((conQueue = this.connectionsPool.putIfAbsent(uri, newPool = this.delayedExecutor.createIdleConnectionQueue(this.timeout, this.maxConnectionLifeTimeInMs))) == null) {
                conQueue = newPool;
            }
        }
        int size = conQueue.size();
        if (this.maxConnectionsPerHost == -1 || size < this.maxConnectionsPerHost) {
            conQueue.offer(connection);
            connection.addCloseListener(this.listener);
            int total = this.totalCachedConnections.incrementAndGet();
            if (LOG.isDebugEnabled()) {
                LOG.debug("[offer] Pooling connection [{}] for uri [{}].  Current size (for host; before pooling): [{}].  Max size (for host): [{}].  Total number of cached connections: [{}].", new Object[]{connection, uri, size, this.maxConnectionsPerHost, total});
            }
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("[offer] Unable to pool connection [{}] for uri [{}]. Current size (for host): [{}].  Max size (for host): [{}].  Total number of cached connections: [{}].", new Object[]{connection, uri, size, this.maxConnectionsPerHost, this.totalCachedConnections.get()});
        }
        return false;
    }

    @Override
    public Connection poll(String uri) {
        if (!this.cacheSSLConnections && this.isSecure(uri)) {
            return null;
        }
        Connection connection = null;
        DelayedExecutor.IdleConnectionQueue conQueue = this.connectionsPool.get(uri);
        if (conQueue != null) {
            boolean poolEmpty = false;
            while (!poolEmpty && connection == null) {
                if (!conQueue.isEmpty()) {
                    connection = conQueue.poll();
                }
                if (connection == null) {
                    poolEmpty = true;
                    continue;
                }
                if (connection.isOpen()) continue;
                this.removeAll(connection);
                connection = null;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("[poll] No existing queue for uri [{}].", new Object[]{uri});
        }
        if (connection != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[poll] Found pooled connection [{}] for uri [{}].", new Object[]{connection, uri});
            }
            this.totalCachedConnections.decrementAndGet();
            connection.removeCloseListener(this.listener);
        }
        return connection;
    }

    @Override
    public boolean removeAll(Connection connection) {
        if (connection == null || this.closed.get()) {
            return false;
        }
        connection.removeCloseListener(this.listener);
        boolean isRemoved = false;
        for (Map.Entry<String, DelayedExecutor.IdleConnectionQueue> entry : this.connectionsPool.entrySet()) {
            boolean removed = entry.getValue().remove(connection);
            isRemoved |= removed;
        }
        if (isRemoved) {
            this.totalCachedConnections.decrementAndGet();
        }
        return isRemoved;
    }

    @Override
    public boolean canCacheConnection() {
        return this.closed.get() || this.unlimitedConnections || this.totalCachedConnections.get() < this.maxConnections;
    }

    @Override
    public void destroy() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        for (Map.Entry<String, DelayedExecutor.IdleConnectionQueue> entry : this.connectionsPool.entrySet()) {
            entry.getValue().destroy();
        }
        this.connectionsPool.clear();
        if (this.ownsDelayedExecutor) {
            this.delayedExecutor.stop();
            this.delayedExecutor.getThreadPool().shutdownNow();
        }
    }

    private boolean isSecure(String uri) {
        return uri.startsWith("https") || uri.startsWith("wss");
    }

    public static final class DelayedExecutor {
        public static final long UNSET_TIMEOUT = -1L;
        private final ExecutorService threadPool;
        private final DelayedRunnable runnable = new DelayedRunnable();
        private final BlockingQueue<IdleConnectionQueue> queues = DataStructures.getLTQInstance(IdleConnectionQueue.class);
        private final Object sync = new Object();
        private volatile boolean isStarted;
        private final long checkIntervalMs;
        private final AtomicInteger totalCachedConnections;

        public DelayedExecutor(ExecutorService threadPool, GrizzlyConnectionsPool connectionsPool) {
            this(threadPool, 1000L, TimeUnit.MILLISECONDS, connectionsPool);
        }

        public DelayedExecutor(ExecutorService threadPool, long checkInterval, TimeUnit timeunit, GrizzlyConnectionsPool connectionsPool) {
            this.threadPool = threadPool;
            this.checkIntervalMs = TimeUnit.MILLISECONDS.convert(checkInterval, timeunit);
            this.totalCachedConnections = connectionsPool.totalCachedConnections;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void start() {
            Object object = this.sync;
            synchronized (object) {
                if (!this.isStarted) {
                    this.isStarted = true;
                    this.threadPool.execute(this.runnable);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() {
            Object object = this.sync;
            synchronized (object) {
                if (this.isStarted) {
                    this.isStarted = false;
                    this.sync.notify();
                }
            }
        }

        private ExecutorService getThreadPool() {
            return this.threadPool;
        }

        private IdleConnectionQueue createIdleConnectionQueue(long timeout, long maxConnectionLifeTimeInMs) {
            IdleConnectionQueue queue = new IdleConnectionQueue(timeout, maxConnectionLifeTimeInMs);
            this.queues.add(queue);
            return queue;
        }

        private static boolean wasModified(long l1, long l2) {
            return l1 != l2;
        }

        static final class TimeoutResolver {
            private static final String IDLE_ATTRIBUTE_NAME = "grizzly-ahc-conn-pool-idle-attribute";
            private static final Attribute<IdleRecord> IDLE_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("grizzly-ahc-conn-pool-idle-attribute", (NullaryFunction)new NullaryFunction<IdleRecord>(){

                public IdleRecord evaluate() {
                    return new IdleRecord();
                }
            });

            TimeoutResolver() {
            }

            boolean removeTimeout(Connection c) {
                ((IdleRecord)TimeoutResolver.IDLE_ATTR.get((AttributeStorage)c)).timeoutMs = 0L;
                return true;
            }

            long getTimeoutMs(Connection c) {
                return ((IdleRecord)TimeoutResolver.IDLE_ATTR.get((AttributeStorage)c)).timeoutMs;
            }

            void setTimeoutMs(Connection c, long timeoutMs) {
                ((IdleRecord)TimeoutResolver.IDLE_ATTR.get((AttributeStorage)c)).timeoutMs = timeoutMs;
            }

            static final class IdleRecord {
                volatile long timeoutMs = -1L;

                IdleRecord() {
                }
            }
        }

        final class IdleConnectionQueue {
            final ConcurrentLinkedQueue<Connection> queue = new ConcurrentLinkedQueue();
            final TimeoutResolver resolver = new TimeoutResolver();
            final long timeout;
            final AtomicInteger count = new AtomicInteger(0);
            final long maxConnectionLifeTimeInMs;

            public IdleConnectionQueue(long timeout, long maxConnectionLifeTimeInMs) {
                this.timeout = timeout;
                this.maxConnectionLifeTimeInMs = maxConnectionLifeTimeInMs;
            }

            void offer(Connection c) {
                long timeoutMs = -1L;
                long currentTime = DateUtil.millisTime();
                if (this.maxConnectionLifeTimeInMs < 0L && this.timeout >= 0L) {
                    timeoutMs = currentTime + this.timeout;
                } else if (this.maxConnectionLifeTimeInMs >= 0L) {
                    long t = this.resolver.getTimeoutMs(c);
                    if (t == -1L) {
                        timeoutMs = this.timeout >= 0L ? currentTime + Math.min(this.maxConnectionLifeTimeInMs, this.timeout) : currentTime + this.maxConnectionLifeTimeInMs;
                    } else if (this.timeout >= 0L) {
                        timeoutMs = Math.min(t, currentTime + this.timeout);
                    }
                }
                this.resolver.setTimeoutMs(c, timeoutMs);
                this.queue.offer(c);
                this.count.incrementAndGet();
            }

            Connection poll() {
                this.count.decrementAndGet();
                return this.queue.poll();
            }

            boolean remove(Connection c) {
                if (this.timeout >= 0L) {
                    this.resolver.removeTimeout(c);
                }
                this.count.decrementAndGet();
                return this.queue.remove(c);
            }

            int size() {
                return this.count.get();
            }

            boolean isEmpty() {
                return this.count.get() == 0;
            }

            void destroy() {
                for (Connection c : this.queue) {
                    c.close();
                }
                this.queue.clear();
                DelayedExecutor.this.queues.remove(this);
            }
        }

        private class DelayedRunnable
        implements Runnable {
            private DelayedRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (DelayedExecutor.this.isStarted) {
                    long currentTimeMs = DateUtil.millisTime();
                    for (IdleConnectionQueue delayQueue : DelayedExecutor.this.queues) {
                        if (delayQueue.queue.isEmpty()) continue;
                        TimeoutResolver resolver = delayQueue.resolver;
                        Iterator<Connection> it = delayQueue.queue.iterator();
                        while (it.hasNext()) {
                            Connection element = it.next();
                            Long timeoutMs = resolver.getTimeoutMs(element);
                            if (timeoutMs == -1L) {
                                it.remove();
                                if (!DelayedExecutor.wasModified(timeoutMs, resolver.getTimeoutMs(element))) continue;
                                delayQueue.queue.offer(element);
                                continue;
                            }
                            if (currentTimeMs - timeoutMs < 0L) continue;
                            it.remove();
                            if (DelayedExecutor.wasModified(timeoutMs, resolver.getTimeoutMs(element))) {
                                delayQueue.queue.offer(element);
                                continue;
                            }
                            try {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Idle connection ({}) detected.  Removing from cache.", (Object)element.toString());
                                }
                                DelayedExecutor.this.totalCachedConnections.decrementAndGet();
                                element.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    Object object = DelayedExecutor.this.sync;
                    synchronized (object) {
                        if (!DelayedExecutor.this.isStarted) {
                            return;
                        }
                        try {
                            DelayedExecutor.this.sync.wait(DelayedExecutor.this.checkIntervalMs);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

