/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.filter;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.filter.AsyncFilter;
import com.ning.http.client.filter.AsyncFilterContext;
import com.ning.http.client.filter.AsyncFilterException;
import com.ning.http.client.logging.LogManager;
import com.ning.http.client.logging.Logger;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class ThrottleRequestAsyncFilter
implements AsyncFilter {
    private static final Logger logger = LogManager.getLogger(ThrottleRequestAsyncFilter.class);
    private final int maxConnections;
    private final Semaphore available;
    private final int maxWait;

    public ThrottleRequestAsyncFilter(int maxConnections) {
        this.maxConnections = maxConnections;
        this.maxWait = Integer.MAX_VALUE;
        this.available = new Semaphore(maxConnections, true);
    }

    public ThrottleRequestAsyncFilter(int maxConnections, int maxWait) {
        this.maxConnections = maxConnections;
        this.maxWait = maxWait;
        this.available = new Semaphore(maxConnections, true);
    }

    public AsyncFilterContext filter(AsyncFilterContext ctx) throws AsyncFilterException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Current Throttling Status %s", this.available.availablePermits()), new Object[0]);
            }
            if (!this.available.tryAcquire(this.maxWait, TimeUnit.MILLISECONDS)) {
                throw new AsyncFilterException(String.format("No slot available for processing Request %s with AsyncHandler %s", ctx.getRequest(), ctx.getAsyncHandler()));
            }
        }
        catch (InterruptedException e) {
            throw new AsyncFilterException(String.format("Interrupted Request %s with AsyncHandler %s", ctx.getRequest(), ctx.getAsyncHandler()));
        }
        return new AsyncFilterContext(new AsyncHandlerWrapper(ctx.getAsyncHandler()), ctx.getRequest());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AsyncHandlerWrapper<T>
    implements AsyncHandler {
        private final AsyncHandler<T> asyncHandler;

        public AsyncHandlerWrapper(AsyncHandler<T> asyncHandler) {
            this.asyncHandler = asyncHandler;
        }

        @Override
        public void onThrowable(Throwable t) {
            this.asyncHandler.onThrowable(t);
        }

        @Override
        public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
            return this.asyncHandler.onBodyPartReceived(bodyPart);
        }

        @Override
        public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
            return this.asyncHandler.onStatusReceived(responseStatus);
        }

        @Override
        public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
            return this.asyncHandler.onHeadersReceived(headers);
        }

        @Override
        public T onCompleted() throws Exception {
            ThrottleRequestAsyncFilter.this.available.release();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Current Throttling Status %s", ThrottleRequestAsyncFilter.this.available.availablePermits()), new Object[0]);
            }
            return this.asyncHandler.onCompleted();
        }
    }
}

