/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.jdk;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.ConnectionsPool;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.MaxRedirectException;
import com.ning.http.client.PerRequestConfig;
import com.ning.http.client.ProgressAsyncHandler;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.logging.LogManager;
import com.ning.http.client.logging.Logger;
import com.ning.http.client.providers.jdk.JDKAsyncHttpProviderConfig;
import com.ning.http.client.providers.jdk.JDKConnectionsPool;
import com.ning.http.client.providers.jdk.JDKFuture;
import com.ning.http.client.providers.jdk.JDKResponse;
import com.ning.http.client.providers.jdk.ResponseBodyPart;
import com.ning.http.client.providers.jdk.ResponseHeaders;
import com.ning.http.client.providers.jdk.ResponseStatus;
import com.ning.http.multipart.MultipartRequestEntity;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.SslUtils;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import javax.naming.AuthenticationException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKAsyncHttpProvider
implements AsyncHttpProvider<HttpURLConnection> {
    private static final Logger logger = LogManager.getLogger(JDKAsyncHttpProvider.class);
    private static final String NTLM_DOMAIN = "http.auth.ntlm.domain";
    private final AsyncHttpClientConfig config;
    private final AtomicBoolean isClose = new AtomicBoolean(false);
    private final ConnectionsPool<String, URLConnection> connectionsPool;
    private static final int MAX_BUFFERED_BYTES = 8192;
    private final AtomicInteger maxConnections = new AtomicInteger();
    private String jdkNtlmDomain;
    private Authenticator jdkAuthenticator;

    public JDKAsyncHttpProvider(AsyncHttpClientConfig config) {
        this.config = config;
        JDKConnectionsPool cp = config.getConnectionsPool();
        if (cp == null) {
            cp = new JDKConnectionsPool(config);
        }
        this.connectionsPool = cp;
        AsyncHttpProviderConfig<?, ?> providerConfig = config.getAsyncHttpProviderConfig();
        if (providerConfig != null && JDKAsyncHttpProviderConfig.class.isAssignableFrom(providerConfig.getClass())) {
            this.configure((JDKAsyncHttpProviderConfig)JDKAsyncHttpProviderConfig.class.cast(providerConfig));
        }
    }

    private void configure(JDKAsyncHttpProviderConfig config) {
    }

    @Override
    public <T> Future<T> execute(Request request, AsyncHandler<T> handler) throws IOException {
        if (this.isClose.get()) {
            throw new IOException("Closed");
        }
        if (this.config.getMaxTotalConnections() > -1 && this.maxConnections.get() + 1 > this.config.getMaxTotalConnections()) {
            throw new IOException(String.format("Too many connections %s", this.config.getMaxTotalConnections()));
        }
        ProxyServer proxyServer = request.getProxyServer() != null ? request.getProxyServer() : this.config.getProxyServer();
        Proxy proxy = null;
        if (proxyServer != null || request.getRealm() != null) {
            try {
                proxy = this.configureProxyAndAuth(proxyServer, request.getRealm());
            }
            catch (AuthenticationException e) {
                throw new IOException(e.getMessage());
            }
        }
        HttpURLConnection urlConnection = this.createUrlConnection(request);
        JDKFuture<T> f = new JDKFuture<T>(handler, this.config.getRequestTimeoutInMs());
        f.setInnerFuture(this.config.executorService().submit(new AsyncHttpUrlConnection<T>(urlConnection, request, handler, f)));
        this.maxConnections.incrementAndGet();
        return f;
    }

    private HttpURLConnection createUrlConnection(Request request) throws IOException {
        ProxyServer proxyServer = request.getProxyServer() != null ? request.getProxyServer() : this.config.getProxyServer();
        Proxy proxy = null;
        if (proxyServer != null || request.getRealm() != null) {
            try {
                proxy = this.configureProxyAndAuth(proxyServer, request.getRealm());
            }
            catch (AuthenticationException e) {
                throw new IOException(e.getMessage());
            }
        }
        HttpURLConnection urlConnection = null;
        urlConnection = proxy == null ? (HttpURLConnection)AsyncHttpProviderUtils.createUri(request.getUrl()).toURL().openConnection() : (HttpURLConnection)AsyncHttpProviderUtils.createUri(request.getUrl()).toURL().openConnection(proxy);
        if (request.getUrl().startsWith("https")) {
            HttpsURLConnection secure = (HttpsURLConnection)urlConnection;
            SSLContext sslContext = this.config.getSSLContext();
            if (sslContext == null) {
                try {
                    sslContext = SslUtils.getSSLContext();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IOException(e.getMessage());
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e.getMessage());
                }
            }
            secure.setSSLSocketFactory(sslContext.getSocketFactory());
            secure.setHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
        }
        return urlConnection;
    }

    @Override
    public void close() {
        this.isClose.set(true);
    }

    @Override
    public Response prepareResponse(HttpResponseStatus status, HttpResponseHeaders headers, Collection<HttpResponseBodyPart> bodyParts) {
        return new JDKResponse(status, headers, bodyParts);
    }

    private Proxy configureProxyAndAuth(final ProxyServer proxyServer, final Realm realm) throws AuthenticationException {
        boolean hasAuthentication;
        Proxy proxy = null;
        if (proxyServer != null) {
            String proxyHost = proxyServer.getHost().startsWith("http://") ? proxyServer.getHost().substring("http://".length()) : proxyServer.getHost();
            InetSocketAddress addr = new InetSocketAddress(proxyHost, proxyServer.getPort());
            proxy = new Proxy(Proxy.Type.HTTP, addr);
        }
        final boolean hasProxy = proxyServer != null && proxyServer.getPrincipal() != null;
        boolean bl = hasAuthentication = realm != null && realm.getPrincipal() != null;
        if (hasProxy || hasAuthentication) {
            Field f = null;
            try {
                f = Authenticator.class.getDeclaredField("theAuthenticator");
                f.setAccessible(true);
                this.jdkAuthenticator = (Authenticator)f.get(Authenticator.class);
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    if (hasProxy && this.getRequestingHost().equals(proxyServer.getHost()) && this.getRequestingPort() == proxyServer.getPort()) {
                        String password = "";
                        if (proxyServer.getPassword() != null) {
                            password = proxyServer.getPassword();
                        }
                        return new PasswordAuthentication(proxyServer.getPrincipal(), password.toCharArray());
                    }
                    if (hasAuthentication) {
                        return new PasswordAuthentication(realm.getPrincipal(), realm.getPassword().toCharArray());
                    }
                    return super.getPasswordAuthentication();
                }
            });
        } else {
            Authenticator.setDefault(null);
        }
        return proxy;
    }

    private InputStream getInputStream(HttpURLConnection urlConnection) throws IOException {
        if (urlConnection.getResponseCode() < 400) {
            return urlConnection.getInputStream();
        }
        InputStream ein = urlConnection.getErrorStream();
        return ein != null ? ein : new ByteArrayInputStream(new byte[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AsyncHttpUrlConnection<T>
    implements Callable<T> {
        private final HttpURLConnection urlConnection;
        private final Request request;
        private final AsyncHandler<T> asyncHandler;
        private final JDKFuture future;
        private Request currentRequest;
        private HttpURLConnection currentUrlConnection;
        private int currentRedirectCount;

        public AsyncHttpUrlConnection(HttpURLConnection urlConnection, Request request, AsyncHandler<T> asyncHandler, JDKFuture future) {
            this.urlConnection = urlConnection;
            this.request = request;
            this.asyncHandler = asyncHandler;
            this.future = future;
            this.currentRequest = request;
            this.currentUrlConnection = urlConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            AsyncHandler.STATE state = AsyncHandler.STATE.ABORT;
            try {
                boolean redirectEnabled;
                URI uri = null;
                try {
                    uri = AsyncHttpProviderUtils.createUri(this.currentRequest.getRawUrl());
                }
                catch (IllegalArgumentException u) {
                    uri = AsyncHttpProviderUtils.createUri(this.currentRequest.getUrl());
                }
                this.configure(uri, this.currentUrlConnection, this.currentRequest);
                this.currentUrlConnection.connect();
                int statusCode = this.currentUrlConnection.getResponseCode();
                boolean bl = redirectEnabled = this.request.isRedirectEnabled() || JDKAsyncHttpProvider.this.config.isRedirectEnabled();
                if (redirectEnabled && (statusCode == 302 || statusCode == 301)) {
                    if (this.currentRedirectCount++ < JDKAsyncHttpProvider.this.config.getMaxRedirects()) {
                        String location = this.currentUrlConnection.getHeaderField("Location");
                        if (location.startsWith("/")) {
                            location = AsyncHttpProviderUtils.getBaseUrl(uri) + location;
                        }
                        if (!location.equals(uri.toString())) {
                            URI newUri = AsyncHttpProviderUtils.createUri(location);
                            RequestBuilder builder = new RequestBuilder(this.currentRequest);
                            String newUrl = newUri.toString();
                            if (logger.isDebugEnabled()) {
                                logger.debug(String.format("[" + Thread.currentThread().getName() + "] Redirecting to %s", newUrl), new Object[0]);
                            }
                            this.currentRequest = builder.setUrl(newUrl).build();
                            this.currentUrlConnection = JDKAsyncHttpProvider.this.createUrlConnection(this.currentRequest);
                            T t = this.call();
                            return t;
                        }
                    } else {
                        throw new MaxRedirectException("Maximum redirect reached: " + JDKAsyncHttpProvider.this.config.getMaxRedirects());
                    }
                }
                if ((state = this.asyncHandler.onStatusReceived(new ResponseStatus(uri, this.currentUrlConnection, JDKAsyncHttpProvider.this))) == AsyncHandler.STATE.CONTINUE) {
                    state = this.asyncHandler.onHeadersReceived(new ResponseHeaders(uri, this.currentUrlConnection, JDKAsyncHttpProvider.this));
                }
                if (state == AsyncHandler.STATE.CONTINUE) {
                    boolean isGZipped;
                    InputStream is = JDKAsyncHttpProvider.this.getInputStream(this.currentUrlConnection);
                    String contentEncoding = this.currentUrlConnection.getHeaderField("Content-Encoding");
                    boolean bl2 = isGZipped = contentEncoding == null ? false : "gzip".equalsIgnoreCase(contentEncoding);
                    if (isGZipped) {
                        is = new GZIPInputStream(is);
                    }
                    int[] lengthWrapper = new int[1];
                    byte[] bytes = AsyncHttpProviderUtils.readFully(is, lengthWrapper);
                    if (lengthWrapper[0] > 0) {
                        byte[] body = new byte[lengthWrapper[0]];
                        System.arraycopy(bytes, 0, body, 0, lengthWrapper[0]);
                        this.asyncHandler.onBodyPartReceived(new ResponseBodyPart(uri, body, JDKAsyncHttpProvider.this));
                    }
                }
                if (ProgressAsyncHandler.class.isAssignableFrom(this.asyncHandler.getClass())) {
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onHeaderWriteCompleted();
                    ((ProgressAsyncHandler)ProgressAsyncHandler.class.cast(this.asyncHandler)).onContentWriteCompleted();
                }
                T t = this.asyncHandler.onCompleted();
                return t;
            }
            catch (Throwable t) {
                if (logger.isDebugEnabled()) {
                    logger.debug(t);
                }
                try {
                    this.future.abort(this.filterException(t));
                }
                catch (Throwable t2) {
                    logger.error(t2);
                }
            }
            finally {
                if (JDKAsyncHttpProvider.this.config.getMaxTotalConnections() != -1) {
                    JDKAsyncHttpProvider.this.maxConnections.decrementAndGet();
                }
                this.currentUrlConnection.disconnect();
                if (JDKAsyncHttpProvider.this.jdkNtlmDomain != null) {
                    System.setProperty(JDKAsyncHttpProvider.NTLM_DOMAIN, JDKAsyncHttpProvider.this.jdkNtlmDomain);
                }
                Authenticator.setDefault(JDKAsyncHttpProvider.this.jdkAuthenticator);
            }
            return null;
        }

        private Throwable filterException(Throwable t) {
            if (UnknownHostException.class.isAssignableFrom(t.getClass())) {
                t = new ConnectException(t.getMessage());
            }
            if (SocketTimeoutException.class.isAssignableFrom(t.getClass())) {
                t = new TimeoutException("Request timed out.");
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void configure(URI uri, HttpURLConnection urlConnection, Request request) throws IOException, AuthenticationException {
            Realm realm;
            ProxyServer proxyServer;
            FluentCaseInsensitiveStringsMap h;
            PerRequestConfig conf = request.getPerRequestConfig();
            int requestTimeout = conf != null && conf.getRequestTimeoutInMs() != 0 ? conf.getRequestTimeoutInMs() : JDKAsyncHttpProvider.this.config.getRequestTimeoutInMs();
            urlConnection.setConnectTimeout(JDKAsyncHttpProvider.this.config.getConnectionTimeoutInMs());
            if (requestTimeout != -1) {
                urlConnection.setReadTimeout(requestTimeout);
            }
            urlConnection.setInstanceFollowRedirects(false);
            String host = uri.getHost();
            String method = request.getReqType();
            if (request.getVirtualHost() != null) {
                host = request.getVirtualHost();
            }
            if (uri.getPort() == -1) {
                urlConnection.setRequestProperty("Host", host);
            } else {
                urlConnection.setRequestProperty("Host", host + ":" + uri.getPort());
            }
            if (JDKAsyncHttpProvider.this.config.isCompressionEnabled()) {
                urlConnection.setRequestProperty("Accept-Encoding", "gzip");
            }
            boolean contentTypeSet = false;
            if (!method.equalsIgnoreCase("CONNECT") && (h = request.getHeaders()) != null) {
                for (String name : h.keySet()) {
                    if ("host".equalsIgnoreCase(name)) continue;
                    Iterator i$ = h.get(name).iterator();
                    while (i$.hasNext()) {
                        String value = (String)i$.next();
                        urlConnection.setRequestProperty(name, value);
                    }
                }
            }
            String ka = JDKAsyncHttpProvider.this.config.getKeepAlive() ? "keep-alive" : "close";
            urlConnection.setRequestProperty("Connection", ka);
            ProxyServer proxyServer2 = proxyServer = request.getProxyServer() != null ? request.getProxyServer() : JDKAsyncHttpProvider.this.config.getProxyServer();
            if (proxyServer != null) {
                urlConnection.setRequestProperty("Proxy-Connection", ka);
                if (proxyServer.getPrincipal() != null) {
                    urlConnection.setRequestProperty("Proxy-Authorization", AuthenticatorUtils.computeBasicAuthentication(proxyServer));
                }
            }
            if ((realm = request.getRealm()) != null && realm.getUsePreemptiveAuth()) {
                switch (realm.getAuthScheme()) {
                    case BASIC: {
                        urlConnection.setRequestProperty("Authorization", AuthenticatorUtils.computeBasicAuthentication(realm));
                        break;
                    }
                    case DIGEST: {
                        if (realm.getNonce() == null || realm.getNonce().equals("")) break;
                        try {
                            urlConnection.setRequestProperty("Authorization", AuthenticatorUtils.computeDigestAuthentication(realm));
                            break;
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new SecurityException(e);
                        }
                    }
                    default: {
                        throw new IllegalStateException(String.format("[" + Thread.currentThread().getName() + "] Invalid Authentication %s", realm.toString()));
                    }
                }
            }
            if (realm != null && realm.getDomain() != null && realm.getScheme() == Realm.AuthScheme.NTLM) {
                JDKAsyncHttpProvider.this.jdkNtlmDomain = System.getProperty(JDKAsyncHttpProvider.NTLM_DOMAIN);
                System.setProperty(JDKAsyncHttpProvider.NTLM_DOMAIN, realm.getDomain());
            }
            if (request.getHeaders().getFirstValue("Accept") == null) {
                urlConnection.setRequestProperty("Accept", "*/*");
            }
            if (JDKAsyncHttpProvider.this.config.getUserAgent() != null) {
                urlConnection.setRequestProperty("User-Agent", JDKAsyncHttpProvider.this.config.getUserAgent() + " (JDKAsyncHttpProvider)");
            }
            if (request.getCookies() != null && !request.getCookies().isEmpty()) {
                urlConnection.setRequestProperty("Cookie", AsyncHttpProviderUtils.encodeCookies(request.getCookies()));
            }
            String reqType = request.getReqType();
            urlConnection.setRequestMethod(reqType);
            if ("POST".equals(reqType) || "PUT".equals(reqType)) {
                urlConnection.setRequestProperty("Content-Length", "0");
                urlConnection.setDoOutput(true);
                if (request.getByteData() != null) {
                    urlConnection.setRequestProperty("Content-Length", String.valueOf(request.getByteData().length));
                    urlConnection.setFixedLengthStreamingMode(request.getByteData().length);
                    urlConnection.getOutputStream().write(request.getByteData());
                } else if (request.getStringData() != null) {
                    urlConnection.setRequestProperty("Content-Length", String.valueOf(request.getStringData().length()));
                    urlConnection.getOutputStream().write(request.getStringData().getBytes("UTF-8"));
                } else if (request.getStreamData() != null) {
                    int[] lengthWrapper = new int[1];
                    byte[] bytes = AsyncHttpProviderUtils.readFully(request.getStreamData(), lengthWrapper);
                    int length = lengthWrapper[0];
                    urlConnection.setRequestProperty("Content-Length", String.valueOf(length));
                    urlConnection.setFixedLengthStreamingMode(length);
                    urlConnection.getOutputStream().write(bytes, 0, length);
                } else if (request.getParams() != null) {
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry<String, List<String>> paramEntry : request.getParams()) {
                        String key = paramEntry.getKey();
                        for (String value : paramEntry.getValue()) {
                            if (sb.length() > 0) {
                                sb.append("&");
                            }
                            UTF8UrlEncoder.appendEncoded(sb, key);
                            sb.append("=");
                            UTF8UrlEncoder.appendEncoded(sb, value);
                        }
                    }
                    urlConnection.setRequestProperty("Content-Length", String.valueOf(sb.length()));
                    urlConnection.setFixedLengthStreamingMode(sb.length());
                    if (!request.getHeaders().containsKey("Content-Type")) {
                        urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    }
                    urlConnection.getOutputStream().write(sb.toString().getBytes("UTF-8"));
                } else if (request.getParts() != null) {
                    int lenght = (int)request.getLength();
                    if (lenght != -1) {
                        urlConnection.setRequestProperty("Content-Length", String.valueOf(lenght));
                        urlConnection.setFixedLengthStreamingMode(lenght);
                    }
                    if (lenght == -1) {
                        lenght = 8192;
                    }
                    MultipartRequestEntity mre = AsyncHttpProviderUtils.createMultipartRequestEntity(request.getParts(), request.getParams());
                    urlConnection.setRequestProperty("Content-Type", mre.getContentType());
                    urlConnection.setRequestProperty("Content-Length", String.valueOf(mre.getContentLength()));
                    ChannelBuffer b = ChannelBuffers.dynamicBuffer((int)lenght);
                    mre.writeRequest(urlConnection.getOutputStream());
                } else if (request.getEntityWriter() != null) {
                    int lenght = (int)request.getLength();
                    if (lenght != -1) {
                        urlConnection.setRequestProperty("Content-Length", String.valueOf(lenght));
                        urlConnection.setFixedLengthStreamingMode(lenght);
                    }
                    request.getEntityWriter().writeEntity(urlConnection.getOutputStream());
                } else if (request.getFile() != null) {
                    File file = request.getFile();
                    if (file.isHidden() || !file.exists() || !file.isFile()) {
                        throw new IOException(String.format("[" + Thread.currentThread().getName() + "] File %s is not a file, is hidden or doesn't exist", file.getAbsolutePath()));
                    }
                    long lenght = new RandomAccessFile(file, "r").length();
                    urlConnection.setRequestProperty("Content-Length", String.valueOf(lenght));
                    urlConnection.setFixedLengthStreamingMode((int)lenght);
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        byte[] buffer = new byte[(int)lenght];
                        fis.read(buffer);
                        urlConnection.getOutputStream().write(buffer);
                    }
                    finally {
                        fis.close();
                    }
                }
            }
        }
    }
}

