/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.ConnectionsPool;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.SSLEngineFactory;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncHttpClientConfig {
    private static final String ASYNC_CLIENT = AsyncHttpClientConfig.class.getName() + ".";
    private final int maxTotalConnections;
    private final int maxConnectionPerHost;
    private final int connectionTimeOutInMs;
    private final int idleConnectionTimeoutInMs;
    private final int requestTimeoutInMs;
    private final boolean redirectEnabled;
    private final int maxDefaultRedirects;
    private final boolean compressionEnabled;
    private final String userAgent;
    private final boolean keepAlive;
    private final ScheduledExecutorService reaper;
    private final ExecutorService applicationThreadPool;
    private final ProxyServer proxyServer;
    private final SSLContext sslContext;
    private final SSLEngineFactory sslEngineFactory;
    private final AsyncHttpProviderConfig<?, ?> providerConfig;
    private final ConnectionsPool<?, ?> connectionsPool;

    private AsyncHttpClientConfig(int maxTotalConnections, int maxConnectionPerHost, int connectionTimeOutInMs, int idleConnectionTimeoutInMs, int requestTimeoutInMs, boolean redirectEnabled, int maxDefaultRedirects, boolean compressionEnabled, String userAgent, boolean keepAlive, ScheduledExecutorService reaper, ExecutorService applicationThreadPool, ProxyServer proxyServer, SSLContext sslContext, SSLEngineFactory sslEngineFactory, AsyncHttpProviderConfig<?, ?> providerConfig, ConnectionsPool<?, ?> connectionsPool) {
        this.maxTotalConnections = maxTotalConnections;
        this.maxConnectionPerHost = maxConnectionPerHost;
        this.connectionTimeOutInMs = connectionTimeOutInMs;
        this.idleConnectionTimeoutInMs = idleConnectionTimeoutInMs;
        this.requestTimeoutInMs = requestTimeoutInMs;
        this.redirectEnabled = redirectEnabled;
        this.maxDefaultRedirects = maxDefaultRedirects;
        this.compressionEnabled = compressionEnabled;
        this.userAgent = userAgent;
        this.keepAlive = keepAlive;
        this.sslContext = sslContext;
        this.sslEngineFactory = sslEngineFactory;
        this.providerConfig = providerConfig;
        this.connectionsPool = connectionsPool;
        this.reaper = reaper == null ? Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, "AsyncHttpClient-Reaper");
            }
        }) : reaper;
        this.applicationThreadPool = applicationThreadPool == null ? Executors.newCachedThreadPool() : applicationThreadPool;
        this.proxyServer = proxyServer;
    }

    public ScheduledExecutorService reaper() {
        return this.reaper;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public int getMaxConnectionPerHost() {
        return this.maxConnectionPerHost;
    }

    public int getConnectionTimeoutInMs() {
        return this.connectionTimeOutInMs;
    }

    public int getIdleConnectionTimeoutInMs() {
        return this.idleConnectionTimeoutInMs;
    }

    public int getRequestTimeoutInMs() {
        return this.requestTimeoutInMs;
    }

    public boolean isRedirectEnabled() {
        return this.redirectEnabled;
    }

    public int getMaxRedirects() {
        return this.maxDefaultRedirects;
    }

    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public ExecutorService executorService() {
        return this.applicationThreadPool;
    }

    public ProxyServer getProxyServer() {
        return this.proxyServer;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public ConnectionsPool<?, ?> getConnectionsPool() {
        return this.connectionsPool;
    }

    public SSLEngineFactory getSSLEngineFactory() {
        if (this.sslEngineFactory == null) {
            return new SSLEngineFactory(){

                public SSLEngine newSSLEngine() {
                    if (AsyncHttpClientConfig.this.sslContext != null) {
                        SSLEngine sslEngine = AsyncHttpClientConfig.this.sslContext.createSSLEngine();
                        sslEngine.setUseClientMode(true);
                        return sslEngine;
                    }
                    return null;
                }
            };
        }
        return this.sslEngineFactory;
    }

    public AsyncHttpProviderConfig<?, ?> getAsyncHttpProviderConfig() {
        return this.providerConfig;
    }

    static /* synthetic */ String access$100() {
        return ASYNC_CLIENT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private int defaultMaxTotalConnections = Integer.getInteger(AsyncHttpClientConfig.access$100() + "defaultMaxTotalConnections", -1);
        private int defaultMaxConnectionPerHost = Integer.getInteger(AsyncHttpClientConfig.access$100() + "defaultMaxConnectionsPerHost", -1);
        private int defaultConnectionTimeOutInMs = Integer.getInteger(AsyncHttpClientConfig.access$100() + "defaultConnectionTimeoutInMS", 60000);
        private int defaultIdleConnectionTimeoutInMs = Integer.getInteger(AsyncHttpClientConfig.access$100() + "defaultIdleConnectionTimeoutInMS", 60000);
        private int defaultRequestTimeoutInMs = Integer.getInteger(AsyncHttpClientConfig.access$100() + "defaultRequestTimeoutInMS", 60000);
        private boolean redirectEnabled = Boolean.getBoolean(AsyncHttpClientConfig.access$100() + "defaultRedirectsEnabled");
        private int maxDefaultRedirects = Integer.getInteger(AsyncHttpClientConfig.access$100() + "defaultMaxRedirects", 5);
        private boolean compressionEnabled = Boolean.getBoolean(AsyncHttpClientConfig.access$100() + "compressionEnabled");
        private String userAgent = System.getProperty(AsyncHttpClientConfig.access$100() + "userAgent", "NING/1.0");
        private boolean keepAlive = true;
        private ScheduledExecutorService reaper = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactory(){

            public Thread newThread(Runnable r) {
                return new Thread(r, "AsyncHttpClient-Reaper");
            }
        });
        private ExecutorService applicationThreadPool = Executors.newCachedThreadPool();
        private ProxyServer proxyServer = null;
        private SSLContext sslContext;
        private SSLEngineFactory sslEngineFactory;
        private AsyncHttpProviderConfig<?, ?> providerConfig;
        private ConnectionsPool<?, ?> connectionsPool;

        public Builder setMaximumConnectionsTotal(int defaultMaxTotalConnections) {
            this.defaultMaxTotalConnections = defaultMaxTotalConnections;
            return this;
        }

        public Builder setMaximumConnectionsPerHost(int defaultMaxConnectionPerHost) {
            this.defaultMaxConnectionPerHost = defaultMaxConnectionPerHost;
            return this;
        }

        public Builder setConnectionTimeoutInMs(int defaultConnectionTimeOutInMs) {
            this.defaultConnectionTimeOutInMs = defaultConnectionTimeOutInMs;
            return this;
        }

        public Builder setIdleConnectionTimeoutInMs(int defaultIdleConnectionTimeoutInMs) {
            this.defaultIdleConnectionTimeoutInMs = defaultIdleConnectionTimeoutInMs;
            return this;
        }

        public Builder setRequestTimeoutInMs(int defaultRequestTimeoutInMs) {
            this.defaultRequestTimeoutInMs = defaultRequestTimeoutInMs;
            return this;
        }

        public Builder setFollowRedirects(boolean redirectEnabled) {
            this.redirectEnabled = redirectEnabled;
            return this;
        }

        public Builder setMaximumNumberOfRedirects(int maxDefaultRedirects) {
            this.maxDefaultRedirects = maxDefaultRedirects;
            return this;
        }

        public Builder setCompressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public Builder setKeepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder setScheduledExecutorService(ScheduledExecutorService reaper) {
            if (this.reaper != null) {
                this.reaper.shutdown();
            }
            this.reaper = reaper;
            return this;
        }

        public Builder setExecutorService(ExecutorService applicationThreadPool) {
            if (this.applicationThreadPool != null) {
                this.applicationThreadPool.shutdown();
            }
            this.applicationThreadPool = applicationThreadPool;
            return this;
        }

        public Builder setProxyServer(ProxyServer proxyServer) {
            this.proxyServer = proxyServer;
            return this;
        }

        public Builder setSSLEngineFactory(SSLEngineFactory sslEngineFactory) {
            this.sslEngineFactory = sslEngineFactory;
            return this;
        }

        public Builder setSSLContext(final SSLContext sslContext) {
            this.sslEngineFactory = new SSLEngineFactory(){

                public SSLEngine newSSLEngine() throws GeneralSecurityException {
                    SSLEngine sslEngine = sslContext.createSSLEngine();
                    sslEngine.setUseClientMode(true);
                    return sslEngine;
                }
            };
            this.sslContext = sslContext;
            return this;
        }

        public Builder setAsyncHttpClientProviderConfig(AsyncHttpProviderConfig<?, ?> providerConfig) {
            this.providerConfig = providerConfig;
            return this;
        }

        public Builder setConnectionsPool(ConnectionsPool<?, ?> connectionsPool) {
            this.connectionsPool = connectionsPool;
            return this;
        }

        public AsyncHttpClientConfig build() {
            return new AsyncHttpClientConfig(this.defaultMaxTotalConnections, this.defaultMaxConnectionPerHost, this.defaultConnectionTimeOutInMs, this.defaultIdleConnectionTimeoutInMs, this.defaultRequestTimeoutInMs, this.redirectEnabled, this.maxDefaultRedirects, this.compressionEnabled, this.userAgent, this.keepAlive, this.reaper, this.applicationThreadPool, this.proxyServer, this.sslContext, this.sslEngineFactory, this.providerConfig, this.connectionsPool);
        }
    }
}

