/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.srp6.cli;

import com.nimbusds.srp6.BigIntegerUtils;
import com.nimbusds.srp6.SRP6ClientCredentials;
import com.nimbusds.srp6.SRP6ClientSession;
import com.nimbusds.srp6.SRP6CryptoParams;
import com.nimbusds.srp6.SRP6Exception;
import com.nimbusds.srp6.SRP6VerifierGenerator;
import com.nimbusds.srp6.cli.SRP6Tool;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SRP6Client
extends SRP6Tool {
    protected SecureRandom random = new SecureRandom();

    @Override
    public void run() throws IOException, SRP6Exception {
        String mode;
        this.println("*** Nimbus SRP-6a client / verifier generator ***");
        this.println();
        this.println("Choose mode: ");
        this.println("\t1 = generate password verifier");
        this.println("\t2 = client auth session");
        this.println();
        this.print("Your choice [1]: ");
        switch (mode = this.readInput("1")) {
            case "1": {
                this.println();
                this.generatePasswordVerifier();
                break;
            }
            case "2": {
                this.println();
                this.clientSession();
                break;
            }
            default: {
                this.println("Unknown choice, aborting...");
            }
        }
    }

    private void generatePasswordVerifier() throws IOException {
        int saltBytes;
        this.println("Initialize verifier generator");
        SRP6CryptoParams config = this.getConfig("\t");
        SRP6VerifierGenerator vGen = new SRP6VerifierGenerator(config);
        User user = this.getUser("");
        this.println();
        this.print("Enter preferred salt 's' byte size [16]: ");
        String ss = this.readInput("16");
        try {
            saltBytes = Integer.parseInt(ss);
        }
        catch (NumberFormatException e) {
            this.println("Couldn't parse salt 's' byte size: " + e.getMessage());
            return;
        }
        BigInteger s = BigIntegerUtils.bigIntegerFromBytes(vGen.generateRandomSalt(saltBytes, this.random));
        BigInteger v = vGen.generateVerifier(s, user.I, user.P);
        this.logSalt(BigIntegerUtils.toHex(s));
        this.println();
        this.logV(BigIntegerUtils.toHex(v));
    }

    protected void logV(String V) {
        this.println("Computed password verifier 'v' (hex): " + V);
    }

    protected void logSalt(String s) {
        this.println("Generated salt 's' (hex): " + s);
    }

    private void clientSession() throws IOException, SRP6Exception {
        SRP6ClientCredentials cred;
        this.println("Client session step 1");
        SRP6ClientSession client = new SRP6ClientSession(){
            {
                this.random = SRP6Client.this.random;
            }
        };
        User user = this.getUser("\t");
        client.step1(user.I, user.P);
        this.println();
        this.println("Client session step 2");
        SRP6CryptoParams config = this.getConfig("\t");
        this.print("\tEnter salt 's' (hex): ");
        BigInteger s = this.readBigInteger();
        this.println();
        this.print("\tEnter public server value 'B' (hex): ");
        BigInteger B = this.readBigInteger();
        this.println();
        try {
            cred = client.step2(config, s, B);
        }
        catch (SRP6Exception e) {
            this.println(e.getMessage());
            return;
        }
        this.logA(BigIntegerUtils.toHex(cred.A));
        this.logM1(BigIntegerUtils.toHex(cred.M1));
        this.println();
        this.println("Client session step 3");
        this.print("\tEnter server evidence message 'M2' (hex): ");
        BigInteger M2 = this.readBigInteger();
        try {
            client.step3(M2);
        }
        catch (SRP6Exception e) {
            this.println(e.getMessage());
            throw e;
        }
        this.println();
        this.println("Client authentication successfully completed");
        this.println();
        this.logS(BigIntegerUtils.toHex(client.getSessionKey()));
        this.logShash(client.getSessionKeyHash());
    }

    void logM1(String M1) {
        this.println("\tComputed evidence message 'M1' (hex): " + M1);
    }

    void logA(String A) {
        this.println("\tComputed public value 'A' (hex): " + A);
    }

    private User getUser(String prefix) throws IOException {
        this.print(prefix + "Enter user identity 'I': ");
        String I = this.readInput();
        this.print(prefix + "Enter user password 'P': ");
        String P = this.readInput();
        return new User(I, P);
    }

    public static void main(String[] args) throws Exception {
        SRP6Client client = new SRP6Client();
        client.run();
    }

    public static class User {
        public final String I;
        public final String P;

        public User(String I, String P) {
            this.I = I;
            this.P = P;
        }
    }
}

