/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.srp6.cli;

import com.nimbusds.srp6.BigIntegerUtils;
import com.nimbusds.srp6.SRP6CryptoParams;
import com.nimbusds.srp6.SRP6Exception;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import javax.xml.bind.DatatypeConverter;

public abstract class SRP6Tool {
    protected BufferedReader console;

    public SRP6Tool() throws IOException {
        InputStreamReader stdin = new InputStreamReader(System.in);
        this.console = new BufferedReader(stdin);
    }

    public String readInput(String def) throws IOException {
        String input = this.console.readLine();
        if (input == null || input.isEmpty()) {
            if (def != null) {
                return def;
            }
            throw new IOException("Missing input");
        }
        return input.trim();
    }

    public String readInput() throws IOException {
        return this.readInput(null);
    }

    public BigInteger readBigInteger() throws IOException {
        BigInteger bigInt = BigIntegerUtils.fromHex(this.readInput());
        if (bigInt == null) {
            throw new IOException("Bad hex encoding");
        }
        return bigInt;
    }

    public SRP6CryptoParams getConfig(String prefix) throws IOException {
        BigInteger g;
        BigInteger N;
        this.println(prefix + "Enter prime 'N' (hex): ");
        this.println(prefix + "\t1 = select precomputed 256-bit");
        this.println(prefix + "\t2 = select precomputed 512-bit");
        this.println(prefix + "\t3 = select precomputed 768-bit");
        this.println(prefix + "\t4 = select precomputed 1024-bit");
        this.println(prefix + "\t5 = select precomputed 2048-bit");
        this.println(prefix + "\t6 = enter prime 'N' and generator 'g'");
        this.println();
        this.print(prefix + "Your choice [1]: ");
        String choice = this.readInput("1");
        boolean selectedPrecomputed = true;
        switch (choice) {
            case "1": {
                N = SRP6CryptoParams.N_256;
                g = SRP6CryptoParams.g_common;
                break;
            }
            case "2": {
                N = SRP6CryptoParams.N_512;
                g = SRP6CryptoParams.g_common;
                break;
            }
            case "3": {
                N = SRP6CryptoParams.N_768;
                g = SRP6CryptoParams.g_common;
                break;
            }
            case "4": {
                N = SRP6CryptoParams.N_1024;
                g = SRP6CryptoParams.g_common;
                break;
            }
            case "5": {
                N = SRP6CryptoParams.N_2048;
                g = SRP6CryptoParams.g_common;
                break;
            }
            case "6": {
                this.println();
                this.print(prefix + "Enter prime 'N' (hex): ");
                N = this.readBigInteger();
                this.print(prefix + "Enter generator 'g' (hex): ");
                g = this.readBigInteger();
                selectedPrecomputed = false;
                break;
            }
            default: {
                throw new IOException("Unknown choice");
            }
        }
        this.println();
        if (selectedPrecomputed) {
            this.println(prefix + "Selected prime 'N' (hex): " + BigIntegerUtils.toHex(N));
            this.println(prefix + "Selected generator 'g' (hex): " + BigIntegerUtils.toHex(g));
            this.println();
        }
        this.print(prefix + "Enter hash algorithm 'H' [SHA-1]: ");
        String H = this.readInput("SHA-1");
        this.println();
        return new SRP6CryptoParams(N, g, H);
    }

    protected void println() {
        System.out.println();
    }

    protected void print(String s) {
        System.out.print(s);
    }

    protected void println(String msg) {
        System.out.print(msg);
    }

    void logShash(byte[] sessionKeyHash) {
        this.println("\tHashed shared key 'H(S)' (hex): " + DatatypeConverter.printHexBinary((byte[])sessionKeyHash));
    }

    void logS(String S) {
        this.println("\tComputed shared key 'S' (hex): " + S);
    }

    public abstract void run() throws IOException, SRP6Exception;
}

