/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.srp6.cli;

import com.nimbusds.srp6.BigIntegerUtils;
import com.nimbusds.srp6.SRP6CryptoParams;
import com.nimbusds.srp6.SRP6Exception;
import com.nimbusds.srp6.SRP6ServerSession;
import com.nimbusds.srp6.cli.SRP6Tool;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SRP6Server
extends SRP6Tool {
    protected SecureRandom random = new SecureRandom();

    @Override
    public void run() throws IOException {
        BigInteger M2;
        this.println("*** Nimbus SRP-6a server ***");
        this.println();
        this.println("Initialize server session");
        SRP6CryptoParams config = this.getConfig("\t");
        SRP6ServerSession server = new SRP6ServerSession(config){
            {
                this.random = SRP6Server.this.random;
            }
        };
        this.println("Server session step 1");
        this.print("\tEnter user identity 'I': ");
        String I = this.readInput();
        this.print("\tEnter password salt 's' (hex): ");
        BigInteger s = this.readBigInteger();
        this.print("\tEnter password verifier 'v' (hex): ");
        BigInteger v = this.readBigInteger();
        BigInteger B = server.step1(I, s, v);
        this.println();
        this.logB(BigIntegerUtils.toHex(B));
        this.println();
        this.println("Server session step 2");
        this.print("\tEnter client public value 'A' (hex): ");
        BigInteger A = this.readBigInteger();
        this.print("\tEnter client evidence message 'M1' (hex): ");
        BigInteger M1 = this.readBigInteger();
        try {
            M2 = server.step2(A, M1);
        }
        catch (SRP6Exception e) {
            this.println(e.getMessage());
            return;
        }
        this.println();
        this.logM2(BigIntegerUtils.toHex(M2));
        this.println();
        this.println("Mutual authentication successfully completed");
        this.println();
        this.logS(BigIntegerUtils.toHex(server.getSessionKey()));
        this.logShash(server.getSessionKeyHash());
    }

    void logM2(String M2) {
        this.println("\tComputed server evidence message 'M2' (hex): " + M2);
    }

    void logB(String B) {
        this.println("\tComputed public server value 'B' (hex): " + B);
    }

    public static void main(String[] args) throws Exception {
        SRP6Server server = new SRP6Server();
        server.run();
    }
}

