/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.srp6;

import com.nimbusds.srp6.BigIntegerUtils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;

public class SRP6Routines {
    public static BigInteger computeK(MessageDigest digest, BigInteger N, BigInteger g) {
        return SRP6Routines.hashPaddedPair(digest, N, N, g);
    }

    public static byte[] generateRandomSalt(int numBytes) {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[numBytes];
        random.nextBytes(salt);
        return salt;
    }

    public static BigInteger computeX(MessageDigest digest, byte[] salt, byte[] password) {
        byte[] output = digest.digest(password);
        digest.update(salt);
        digest.update(output);
        return BigIntegerUtils.bigIntegerFromBytes(digest.digest());
    }

    public static BigInteger computeVerifier(BigInteger N, BigInteger g, BigInteger x) {
        return g.modPow(x, N);
    }

    public static BigInteger generatePrivateValue(BigInteger N, SecureRandom random) {
        int minBits = Math.min(256, N.bitLength() / 2);
        BigInteger min = BigInteger.ONE.shiftLeft(minBits - 1);
        BigInteger max = N.subtract(BigInteger.ONE);
        return SRP6Routines.createRandomBigIntegerInRange(min, max, random);
    }

    public static BigInteger computePublicClientValue(BigInteger N, BigInteger g, BigInteger a) {
        return g.modPow(a, N);
    }

    public static BigInteger computePublicServerValue(BigInteger N, BigInteger g, BigInteger k, BigInteger v, BigInteger b) {
        return g.modPow(b, N).add(v.multiply(k)).mod(N);
    }

    public static boolean isValidPublicValue(BigInteger N, BigInteger value) {
        return !value.mod(N).equals(BigInteger.ZERO);
    }

    public static BigInteger computeU(MessageDigest digest, BigInteger N, BigInteger A, BigInteger B) {
        return SRP6Routines.hashPaddedPair(digest, N, A, B);
    }

    public static BigInteger computeSessionKey(BigInteger N, BigInteger g, BigInteger k, BigInteger x, BigInteger u, BigInteger a, BigInteger B) {
        BigInteger exp = u.multiply(x).add(a);
        BigInteger tmp = g.modPow(x, N).multiply(k);
        return B.subtract(tmp).modPow(exp, N);
    }

    public static BigInteger computeSessionKey(BigInteger N, BigInteger v, BigInteger u, BigInteger A, BigInteger b) {
        return v.modPow(u, N).multiply(A).modPow(b, N);
    }

    public static BigInteger computeClientEvidence(MessageDigest digest, BigInteger A, BigInteger B, BigInteger S) {
        digest.update(BigIntegerUtils.bigIntegerToBytes(A));
        digest.update(BigIntegerUtils.bigIntegerToBytes(B));
        digest.update(BigIntegerUtils.bigIntegerToBytes(S));
        return BigIntegerUtils.bigIntegerFromBytes(digest.digest());
    }

    protected static BigInteger computeServerEvidence(MessageDigest digest, BigInteger A, BigInteger M1, BigInteger S) {
        digest.update(BigIntegerUtils.bigIntegerToBytes(A));
        digest.update(BigIntegerUtils.bigIntegerToBytes(M1));
        digest.update(BigIntegerUtils.bigIntegerToBytes(S));
        return BigIntegerUtils.bigIntegerFromBytes(digest.digest());
    }

    protected static BigInteger hashPaddedPair(MessageDigest digest, BigInteger N, BigInteger n1, BigInteger n2) {
        int padLength = (N.bitLength() + 7) / 8;
        byte[] n1_bytes = SRP6Routines.getPadded(n1, padLength);
        byte[] n2_bytes = SRP6Routines.getPadded(n2, padLength);
        digest.update(n1_bytes);
        digest.update(n2_bytes);
        byte[] output = digest.digest();
        return BigIntegerUtils.bigIntegerFromBytes(output);
    }

    protected static byte[] getPadded(BigInteger n, int length) {
        byte[] bs = BigIntegerUtils.bigIntegerToBytes(n);
        if (bs.length < length) {
            byte[] tmp = new byte[length];
            System.arraycopy(bs, 0, tmp, length - bs.length, bs.length);
            bs = tmp;
        }
        return bs;
    }

    protected static BigInteger createRandomBigIntegerInRange(BigInteger min, BigInteger max, SecureRandom random) {
        int cmp = min.compareTo(max);
        if (cmp >= 0) {
            if (cmp > 0) {
                throw new IllegalArgumentException("'min' may not be greater than 'max'");
            }
            return min;
        }
        if (min.bitLength() > max.bitLength() / 2) {
            return SRP6Routines.createRandomBigIntegerInRange(BigInteger.ZERO, max.subtract(min), random).add(min);
        }
        int MAX_ITERATIONS = 1000;
        for (int i = 0; i < 1000; ++i) {
            BigInteger x = new BigInteger(max.bitLength(), random);
            if (x.compareTo(min) < 0 || x.compareTo(max) > 0) continue;
            return x;
        }
        return new BigInteger(max.subtract(min).bitLength() - 1, random).add(min);
    }

    private SRP6Routines() {
    }
}

