/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.srp6;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SRP6CryptoParams {
    public static final BigInteger N_256 = new BigInteger("125617018995153554710546479714086468244499594888726646874671447258204721048803");
    public static final BigInteger N_512 = new BigInteger("11144252439149533417835749556168991736939157778924947037200268358613863350040339017097790259154750906072491181606044774215413467851989724116331597513345603");
    public static final BigInteger N_768 = new BigInteger("1087179135105457859072065649059069760280540086975817629066444682366896187793570736574549981488868217843627094867924800342887096064844227836735667168319981288765377499806385489913341488724152562880918438701129530606139552645689583147");
    public static final BigInteger N_1024 = new BigInteger("167609434410335061345139523764350090260135525329813904557420930309800865859473551531551523800013916573891864789934747039010546328480848979516637673776605610374669426214776197828492691384519453218253702788022233205683635831626913357154941914129985489522629902540768368409482248290641036967659389658897350067939");
    public static final BigInteger g_common = BigInteger.valueOf(2L);
    public final BigInteger N;
    public final BigInteger g;
    public final String H;

    public static SRP6CryptoParams getInstance(int bitsize, String H) {
        if (H == null || H.isEmpty()) {
            throw new IllegalArgumentException("Undefined hash algorithm 'H'");
        }
        if (bitsize == 256) {
            return new SRP6CryptoParams(N_256, g_common, H);
        }
        if (bitsize == 512) {
            return new SRP6CryptoParams(N_512, g_common, H);
        }
        if (bitsize == 768) {
            return new SRP6CryptoParams(N_768, g_common, H);
        }
        if (bitsize == 1024) {
            return new SRP6CryptoParams(N_1024, g_common, H);
        }
        return null;
    }

    public static SRP6CryptoParams getInstance() {
        return SRP6CryptoParams.getInstance(512, "SHA-1");
    }

    public static boolean isSupportedHashAlgorithm(String H) {
        try {
            MessageDigest.getInstance(H);
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    public SRP6CryptoParams(BigInteger N, BigInteger g, String H) {
        if (N == null) {
            throw new IllegalArgumentException("The prime parameter 'N' must not be null");
        }
        this.N = N;
        if (g == null) {
            throw new IllegalArgumentException("The generator parameter 'g' must not be null");
        }
        this.g = g;
        if (H == null || H.isEmpty()) {
            throw new IllegalArgumentException("Undefined hash algorithm 'H'");
        }
        if (!SRP6CryptoParams.isSupportedHashAlgorithm(H)) {
            throw new IllegalArgumentException("Unsupported hash algorithm 'H': " + H);
        }
        this.H = H;
    }

    public MessageDigest getMessageDigestInstance() {
        try {
            return MessageDigest.getInstance(this.H);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }
}

