/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.srp6;

import com.nimbusds.srp6.SRP6ClientCredentials;
import com.nimbusds.srp6.SRP6ClientEvidenceContext;
import com.nimbusds.srp6.SRP6CryptoParams;
import com.nimbusds.srp6.SRP6Exception;
import com.nimbusds.srp6.SRP6Routines;
import com.nimbusds.srp6.SRP6ServerEvidenceContext;
import com.nimbusds.srp6.SRP6Session;
import com.nimbusds.srp6.XRoutine;
import java.math.BigInteger;
import java.nio.charset.Charset;

public class SRP6ClientSession
extends SRP6Session {
    private String password;
    private BigInteger x = null;
    private BigInteger a = null;
    private State state = State.INIT;
    private XRoutine xRoutine = null;

    public SRP6ClientSession(int timeout) {
        super(timeout);
        this.updateLastActivityTime();
    }

    public SRP6ClientSession() {
        this(0);
    }

    public void setXRoutine(XRoutine routine) {
        this.xRoutine = routine;
    }

    public XRoutine getXRoutine() {
        return this.xRoutine;
    }

    public void step1(String userID, String password) {
        if (userID == null || userID.trim().isEmpty()) {
            throw new IllegalArgumentException("The user identity 'I' must not be null or empty");
        }
        this.userID = userID;
        if (password == null) {
            throw new IllegalArgumentException("The user password 'P' must not be null");
        }
        this.password = password;
        if (this.state != State.INIT) {
            throw new IllegalStateException("State violation: Session must be in INIT state");
        }
        this.state = State.STEP_1;
        this.updateLastActivityTime();
    }

    public SRP6ClientCredentials step2(SRP6CryptoParams config, BigInteger s, BigInteger B) throws SRP6Exception {
        if (config == null) {
            throw new IllegalArgumentException("The SRP-6a crypto parameters must not be null");
        }
        this.config = config;
        this.digest = config.getMessageDigestInstance();
        if (this.digest == null) {
            throw new IllegalArgumentException("Unsupported hash algorithm 'H': " + config.H);
        }
        if (s == null) {
            throw new IllegalArgumentException("The salt 's' must not be null");
        }
        this.s = s;
        if (B == null) {
            throw new IllegalArgumentException("The public server value 'B' must not be null");
        }
        this.B = B;
        if (this.state != State.STEP_1) {
            throw new IllegalStateException("State violation: Session must be in STEP_1 state");
        }
        if (this.hasTimedOut()) {
            throw new SRP6Exception("Session timeout", SRP6Exception.CauseType.TIMEOUT);
        }
        if (!SRP6Routines.isValidPublicValue(config.N, B)) {
            throw new SRP6Exception("Bad server public value 'B'", SRP6Exception.CauseType.BAD_PUBLIC_VALUE);
        }
        if (this.xRoutine != null) {
            this.x = this.xRoutine.computeX(config.getMessageDigestInstance(), s.toByteArray(), this.userID.getBytes(Charset.forName("UTF-8")), this.password.getBytes(Charset.forName("UTF-8")));
        } else {
            this.x = SRP6Routines.computeX(this.digest, s.toByteArray(), this.password.getBytes(Charset.forName("UTF-8")));
            this.digest.reset();
        }
        this.a = SRP6Routines.generatePrivateValue(config.N, this.random);
        this.digest.reset();
        this.A = SRP6Routines.computePublicClientValue(config.N, config.g, this.a);
        this.k = SRP6Routines.computeK(this.digest, config.N, config.g);
        this.digest.reset();
        this.u = SRP6Routines.computeU(this.digest, config.N, this.A, B);
        this.digest.reset();
        this.S = SRP6Routines.computeSessionKey(config.N, config.g, this.k, this.x, this.u, this.a, B);
        if (this.clientEvidenceRoutine != null) {
            SRP6ClientEvidenceContext ctx = new SRP6ClientEvidenceContext(this.userID, s, this.A, B, this.S);
            this.M1 = this.clientEvidenceRoutine.computeClientEvidence(config, ctx);
        } else {
            this.M1 = SRP6Routines.computeClientEvidence(this.digest, this.A, B, this.S);
            this.digest.reset();
        }
        this.state = State.STEP_2;
        this.updateLastActivityTime();
        return new SRP6ClientCredentials(this.A, this.M1);
    }

    public void step3(BigInteger M2) throws SRP6Exception {
        BigInteger computedM2;
        if (M2 == null) {
            throw new IllegalArgumentException("The server evidence message 'M2' must not be null");
        }
        this.M2 = M2;
        if (this.state != State.STEP_2) {
            throw new IllegalStateException("State violation: Session must be in STEP_2 state");
        }
        if (this.hasTimedOut()) {
            throw new SRP6Exception("Session timeout", SRP6Exception.CauseType.TIMEOUT);
        }
        if (this.serverEvidenceRoutine != null) {
            SRP6ServerEvidenceContext ctx = new SRP6ServerEvidenceContext(this.A, this.M1, this.S);
            computedM2 = this.serverEvidenceRoutine.computeServerEvidence(this.config, ctx);
        } else {
            computedM2 = SRP6Routines.computeServerEvidence(this.digest, this.A, this.M1, this.S);
        }
        if (!computedM2.equals(M2)) {
            throw new SRP6Exception("Bad server credentials", SRP6Exception.CauseType.BAD_CREDENTIALS);
        }
        this.digest.reset();
        this.state = State.STEP_3;
        this.updateLastActivityTime();
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        INIT,
        STEP_1,
        STEP_2,
        STEP_3;

    }
}

