/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.srp6;

import com.nimbusds.srp6.SRP6CryptoParams;
import com.nimbusds.srp6.SRP6Routines;
import com.nimbusds.srp6.XRoutine;
import java.math.BigInteger;
import java.nio.charset.Charset;

public class SRP6VerifierGenerator {
    private SRP6CryptoParams config;
    private XRoutine xRoutine = null;

    public SRP6VerifierGenerator(SRP6CryptoParams config) {
        if (config == null) {
            throw new NullPointerException("The SRP-6a crypto parameters must not be null");
        }
        this.config = config;
    }

    public static byte[] generateRandomSalt(int numBytes) {
        return SRP6Routines.generateRandomSalt(numBytes);
    }

    public static byte[] generateRandomSalt() {
        return SRP6Routines.generateRandomSalt(16);
    }

    public void setXRoutine(XRoutine routine) {
        this.xRoutine = routine;
    }

    public XRoutine getXRoutine() {
        return this.xRoutine;
    }

    public BigInteger generateVerifier(byte[] salt, byte[] userID, byte[] password) {
        if (salt == null) {
            throw new NullPointerException("The salt 's' must not be null");
        }
        if (password == null) {
            throw new NullPointerException("The password 'P' must not be null");
        }
        BigInteger x = null;
        x = this.xRoutine != null ? this.xRoutine.computeX(this.config.getMessageDigestInstance(), salt, userID, password) : SRP6Routines.computeX(this.config.getMessageDigestInstance(), salt, password);
        return SRP6Routines.computeVerifier(this.config.N, this.config.g, x);
    }

    public BigInteger generateVerifier(BigInteger salt, String userID, String password) {
        byte[] userIDBytes = null;
        if (userID != null) {
            userIDBytes = userID.getBytes(Charset.forName("UTF-8"));
        }
        return this.generateVerifier(salt.toByteArray(), userIDBytes, password.getBytes(Charset.forName("UTF-8")));
    }

    public BigInteger generateVerifier(byte[] salt, byte[] password) {
        return this.generateVerifier(salt, null, password);
    }

    public BigInteger generateVerifier(BigInteger salt, String password) {
        return this.generateVerifier(salt, null, password);
    }
}

