/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.srp6;

import com.nimbusds.srp6.ClientEvidenceRoutine;
import com.nimbusds.srp6.SRP6CryptoParams;
import com.nimbusds.srp6.ServerEvidenceRoutine;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

public abstract class SRP6Session {
    protected SRP6CryptoParams config;
    protected MessageDigest digest;
    protected final SecureRandom random = new SecureRandom();
    protected final int timeout;
    protected long lastActivity;
    protected String userID = null;
    protected BigInteger s = null;
    protected BigInteger A = null;
    protected BigInteger B = null;
    protected BigInteger u = null;
    protected BigInteger k = null;
    protected BigInteger S = null;
    protected BigInteger M1 = null;
    protected BigInteger M2 = null;
    protected ClientEvidenceRoutine clientEvidenceRoutine = null;
    protected ServerEvidenceRoutine serverEvidenceRoutine = null;
    private Map<String, Object> attributes = null;

    public SRP6Session(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("The timeout must be zero (no timeout) or greater");
        }
        this.timeout = timeout;
    }

    public SRP6Session() {
        this(0);
    }

    protected void updateLastActivityTime() {
        this.lastActivity = System.currentTimeMillis();
    }

    public long getLastActivityTime() {
        return this.lastActivity;
    }

    public boolean hasTimedOut() {
        if (this.timeout == 0) {
            return false;
        }
        long now = System.currentTimeMillis();
        return now > this.lastActivity + (long)(this.timeout * 1000);
    }

    public SRP6CryptoParams getCryptoParams() {
        return this.config;
    }

    public String getUserID() {
        return this.userID;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setClientEvidenceRoutine(ClientEvidenceRoutine routine) {
        this.clientEvidenceRoutine = routine;
    }

    public ClientEvidenceRoutine getClientEvidenceRoutine() {
        return this.clientEvidenceRoutine;
    }

    public void setServerEvidenceRoutine(ServerEvidenceRoutine routine) {
        this.serverEvidenceRoutine = routine;
    }

    public ServerEvidenceRoutine getServerEvidenceRoutine() {
        return this.serverEvidenceRoutine;
    }

    public BigInteger getSalt() {
        return this.s;
    }

    public BigInteger getPublicClientValue() {
        return this.A;
    }

    public BigInteger getPublicServerValue() {
        return this.B;
    }

    public BigInteger getClientEvidenceMessage() {
        return this.M1;
    }

    public BigInteger getServerEvidenceMessage() {
        return this.M2;
    }

    public BigInteger getSessionKey(boolean doHash) {
        if (this.S == null) {
            return null;
        }
        if (doHash) {
            this.digest.reset();
            return new BigInteger(this.digest.digest(this.S.toByteArray()));
        }
        return this.S;
    }

    public void setAttribute(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("The attribute key must not be null");
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        if (key == null) {
            throw new NullPointerException("The attribute key must not be null");
        }
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }
}

