/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.srp6;

import com.nimbusds.srp6.SRP6ClientEvidenceContext;
import com.nimbusds.srp6.SRP6CryptoParams;
import com.nimbusds.srp6.SRP6Exception;
import com.nimbusds.srp6.SRP6Routines;
import com.nimbusds.srp6.SRP6ServerEvidenceContext;
import com.nimbusds.srp6.SRP6Session;
import java.math.BigInteger;

public class SRP6ServerSession
extends SRP6Session {
    private boolean noSuchUserIdentity = false;
    private BigInteger v = null;
    private BigInteger b = null;
    private State state;

    public SRP6ServerSession(SRP6CryptoParams config, int timeout) {
        super(timeout);
        if (config == null) {
            throw new NullPointerException("The SRP-6a crypto parameters must not be null");
        }
        this.config = config;
        this.digest = config.getMessageDigestInstance();
        if (this.digest == null) {
            throw new IllegalArgumentException("Unsupported hash algorithm 'H': " + config.H);
        }
        this.state = State.INIT;
        this.updateLastActivityTime();
    }

    public SRP6ServerSession(SRP6CryptoParams config) {
        this(config, 0);
    }

    public BigInteger step1(String userID, BigInteger s, BigInteger v) {
        if (userID == null || userID.trim().isEmpty()) {
            throw new IllegalArgumentException("The user identity 'I' must not be null or empty");
        }
        this.userID = userID;
        if (s == null) {
            throw new NullPointerException("The salt 's' must not be null");
        }
        this.s = s;
        if (v == null) {
            throw new NullPointerException("The verifier 'v' must not be null");
        }
        this.v = v;
        if (this.state != State.INIT) {
            throw new IllegalStateException("State violation: Session must be in INIT state");
        }
        this.k = SRP6Routines.computeK(this.digest, this.config.N, this.config.g);
        this.digest.reset();
        this.b = SRP6Routines.generatePrivateValue(this.digest, this.config.N, this.random);
        this.digest.reset();
        this.B = SRP6Routines.computePublicServerValue(this.config.N, this.config.g, this.k, v, this.b);
        this.state = State.STEP_1;
        this.updateLastActivityTime();
        return this.B;
    }

    public BigInteger mockStep1(String userID, BigInteger s, BigInteger v) {
        this.noSuchUserIdentity = true;
        return this.step1(userID, s, v);
    }

    public BigInteger step2(BigInteger A, BigInteger M1) throws SRP6Exception {
        Object ctx;
        if (A == null) {
            throw new NullPointerException("The client public value 'A' must not be null");
        }
        this.A = A;
        if (M1 == null) {
            throw new NullPointerException("The client evidence message 'M1' must not be null");
        }
        this.M1 = M1;
        if (this.state != State.STEP_1) {
            throw new IllegalStateException("State violation: Session must be in STEP_1 state");
        }
        if (this.hasTimedOut()) {
            throw new SRP6Exception("Session timeout", SRP6Exception.CauseType.TIMEOUT);
        }
        if (!SRP6Routines.isValidPublicValue(this.config.N, A)) {
            throw new SRP6Exception("Bad client public value 'A'", SRP6Exception.CauseType.BAD_PUBLIC_VALUE);
        }
        if (this.noSuchUserIdentity) {
            throw new SRP6Exception("Bad client credentials", SRP6Exception.CauseType.BAD_CREDENTIALS);
        }
        this.u = SRP6Routines.computeU(this.digest, this.config.N, A, this.B);
        this.digest.reset();
        this.S = SRP6Routines.computeSessionKey(this.config.N, this.v, this.u, A, this.b);
        BigInteger computedM1 = null;
        if (this.clientEvidenceRoutine != null) {
            ctx = new SRP6ClientEvidenceContext(this.userID, this.s, A, this.B, this.S);
            computedM1 = this.clientEvidenceRoutine.computeClientEvidence(this.config, (SRP6ClientEvidenceContext)ctx);
        } else {
            computedM1 = SRP6Routines.computeClientEvidence(this.digest, A, this.B, this.S);
            this.digest.reset();
        }
        if (!computedM1.equals(M1)) {
            throw new SRP6Exception("Bad client credentials", SRP6Exception.CauseType.BAD_CREDENTIALS);
        }
        this.state = State.STEP_2;
        if (this.serverEvidenceRoutine != null) {
            ctx = new SRP6ServerEvidenceContext(A, M1, this.S);
            this.M2 = this.serverEvidenceRoutine.computeServerEvidence(this.config, (SRP6ServerEvidenceContext)ctx);
        } else {
            this.M2 = SRP6Routines.computeServerEvidence(this.digest, A, M1, this.S);
        }
        this.updateLastActivityTime();
        return this.M2;
    }

    public State getState() {
        return this.state;
    }

    public static enum State {
        INIT,
        STEP_1,
        STEP_2;

    }
}

