/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.srp6;

import java.math.BigInteger;

public class Hex {
    private static final int BASELENGTH = 128;
    private static final int LOOKUPLENGTH = 16;
    private static final byte[] hexNumberTable;

    public static String encode(byte[] bytes) {
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String encode(BigInteger bigint) {
        if (bigint == null) {
            return null;
        }
        return bigint.toString(16);
    }

    public static byte[] decodeToByteArray(String hex) {
        if (hex == null) {
            return null;
        }
        int lengthData = hex.length();
        if (lengthData % 2 != 0) {
            return null;
        }
        char[] binaryData = hex.toCharArray();
        int lengthDecode = lengthData / 2;
        byte[] decodedData = new byte[lengthDecode];
        for (int i = 0; i < lengthDecode; ++i) {
            int temp2;
            int temp1;
            char tempChar = binaryData[i * 2];
            int n = temp1 = tempChar < '\u0080' ? hexNumberTable[tempChar] : -1;
            if (temp1 == -1) {
                return null;
            }
            tempChar = binaryData[i * 2 + 1];
            int n2 = temp2 = tempChar < '\u0080' ? hexNumberTable[tempChar] : -1;
            if (temp2 == -1) {
                return null;
            }
            decodedData[i] = (byte)(temp1 << 4 | temp2);
        }
        return decodedData;
    }

    public static BigInteger decodeToBigInteger(String hex) {
        if (hex == null) {
            return null;
        }
        try {
            return new BigInteger(hex, 16);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Hex() {
    }

    static {
        int i;
        hexNumberTable = new byte[128];
        for (i = 0; i < 128; ++i) {
            Hex.hexNumberTable[i] = -1;
        }
        for (i = 57; i >= 48; --i) {
            Hex.hexNumberTable[i] = (byte)(i - 48);
        }
        for (i = 70; i >= 65; --i) {
            Hex.hexNumberTable[i] = (byte)(i - 65 + 10);
        }
        for (i = 102; i >= 97; --i) {
            Hex.hexNumberTable[i] = (byte)(i - 97 + 10);
        }
    }
}

