/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AbstractOptionallyIdentifiedRequest;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class TokenRequest
extends AbstractOptionallyIdentifiedRequest {
    private final AuthorizationGrant authzGrant;
    private final Scope scope;

    public TokenRequest(URI uri, ClientAuthentication clientAuth, AuthorizationGrant authzGrant, Scope scope) {
        super(uri, clientAuth);
        if (clientAuth == null) {
            throw new IllegalArgumentException("The client authentication must not be null");
        }
        this.authzGrant = authzGrant;
        this.scope = scope;
    }

    public TokenRequest(URI uri, ClientAuthentication clientAuth, AuthorizationGrant authzGrant) {
        this(uri, clientAuth, authzGrant, null);
    }

    public TokenRequest(URI uri, ClientID clientID, AuthorizationGrant authzGrant, Scope scope) {
        super(uri, clientID);
        if (authzGrant.getType().requiresClientAuthentication()) {
            throw new IllegalArgumentException("The \"" + authzGrant.getType() + "\" grant type requires client authentication");
        }
        if (authzGrant.getType().requiresClientID() && clientID == null) {
            throw new IllegalArgumentException("The \"" + authzGrant.getType() + "\" grant type requires a \"client_id\" parameter");
        }
        this.authzGrant = authzGrant;
        this.scope = scope;
    }

    public TokenRequest(URI uri, ClientID clientID, AuthorizationGrant authzGrant) {
        this(uri, clientID, authzGrant, null);
    }

    public TokenRequest(URI uri, AuthorizationGrant authzGrant, Scope scope) {
        this(uri, (ClientID)null, authzGrant, scope);
    }

    public TokenRequest(URI uri, AuthorizationGrant authzGrant) {
        this(uri, (ClientID)null, authzGrant, null);
    }

    public AuthorizationGrant getAuthorizationGrant() {
        return this.authzGrant;
    }

    public Scope getScope() {
        return this.scope;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        URL url;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        try {
            url = this.getEndpointURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new SerializeException(e.getMessage(), e);
        }
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, url);
        httpRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(httpRequest);
        }
        Map<String, String> params = httpRequest.getQueryParameters();
        params.putAll(this.authzGrant.toParameters());
        if (this.scope != null && !this.scope.isEmpty()) {
            params.put("scope", this.scope.toString());
        }
        if (this.getClientID() != null) {
            params.put("client_id", this.getClientID().getValue());
        }
        httpRequest.setQuery(URLUtils.serializeParameters(params));
        return httpRequest;
    }

    public static TokenRequest parse(HTTPRequest httpRequest) throws ParseException {
        URI uri;
        try {
            uri = httpRequest.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), e);
        }
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        ClientAuthentication clientAuth = ClientAuthentication.parse(httpRequest);
        Map<String, String> params = httpRequest.getQueryParameters();
        AuthorizationGrant grant = AuthorizationGrant.parse(params);
        if (clientAuth == null && grant.getType().requiresClientAuthentication()) {
            String msg = "Missing client authentication";
            throw new ParseException(msg, OAuth2Error.INVALID_CLIENT.appendDescription(": " + msg));
        }
        ClientID clientID = null;
        if (clientAuth == null) {
            String clientIDString = params.get("client_id");
            if (clientIDString != null && !clientIDString.trim().isEmpty()) {
                clientID = new ClientID(clientIDString);
            }
            if (clientID == null && grant.getType().requiresClientID()) {
                String msg = "Missing required \"client_id\" parameter";
                throw new ParseException(msg, OAuth2Error.INVALID_REQUEST.appendDescription(": " + msg));
            }
        }
        String scopeValue = params.get("scope");
        Scope scope = null;
        if (scopeValue != null) {
            scope = Scope.parse(scopeValue);
        }
        if (clientAuth != null) {
            return new TokenRequest(uri, clientAuth, grant, scope);
        }
        return new TokenRequest(uri, clientID, grant, scope);
    }
}

