/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.assertions.saml2;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.assertions.saml2.BadSAML2AssertionException;
import com.nimbusds.oauth2.sdk.assertions.saml2.SAML2AssertionDetails;
import com.nimbusds.oauth2.sdk.assertions.saml2.SAML2AssertionDetailsVerifier;
import com.nimbusds.oauth2.sdk.id.Issuer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.jcip.annotations.ThreadSafe;
import org.opensaml.DefaultBootstrap;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.security.credential.BasicCredential;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@ThreadSafe
public class SAML2AssertionValidator {
    private final SAML2AssertionDetailsVerifier detailsVerifier;

    public SAML2AssertionValidator(SAML2AssertionDetailsVerifier detailsVerifier) {
        if (detailsVerifier == null) {
            throw new IllegalArgumentException("The SAML 2.0 assertion details verifier must not be null");
        }
        this.detailsVerifier = detailsVerifier;
    }

    public SAML2AssertionDetailsVerifier getDetailsVerifier() {
        return this.detailsVerifier;
    }

    public static Assertion parse(String xml) throws ParseException {
        XMLObject xmlObject;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new InputSource(new ByteArrayInputStream(xml.getBytes("utf-8"))));
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            xmlObject = unmarshaller.unmarshall(element);
        }
        catch (IOException | ParserConfigurationException | UnmarshallingException | SAXException e) {
            throw new ParseException("SAML 2.0 assertion parsing failed: " + e.getMessage(), e);
        }
        if (!(xmlObject instanceof Assertion)) {
            throw new ParseException("Top-level XML element not a SAML 2.0 assertion");
        }
        return (Assertion)xmlObject;
    }

    public static void verifySignature(Signature signature, Key key) throws BadSAML2AssertionException {
        SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
        try {
            profileValidator.validate(signature);
        }
        catch (ValidationException e) {
            throw new BadSAML2AssertionException("Invalid SAML 2.0 signature format: " + e.getMessage(), e);
        }
        BasicCredential credential = new BasicCredential();
        if (key instanceof SecretKey) {
            credential.setSecretKey((SecretKey)key);
        } else if (key instanceof PublicKey) {
            credential.setPublicKey((PublicKey)key);
            credential.setUsageType(UsageType.SIGNING);
        } else {
            throw new BadSAML2AssertionException("Unsupported key type: " + key.getAlgorithm());
        }
        SignatureValidator signatureValidator = new SignatureValidator((Credential)credential);
        try {
            signatureValidator.validate(signature);
        }
        catch (ValidationException e) {
            throw new BadSAML2AssertionException("Bad SAML 2.0 signature: " + e.getMessage(), e);
        }
    }

    public Assertion validate(Assertion assertion, Issuer expectedIssuer, Key key) throws BadSAML2AssertionException {
        SAML2AssertionDetails assertionDetails;
        try {
            assertionDetails = SAML2AssertionDetails.parse(assertion);
        }
        catch (ParseException e) {
            throw new BadSAML2AssertionException("Invalid SAML 2.0 assertion: " + e.getMessage(), e);
        }
        this.detailsVerifier.verify(assertionDetails);
        if (!expectedIssuer.equals(assertionDetails.getIssuer())) {
            throw new BadSAML2AssertionException("Unexpected issuer: " + assertionDetails.getIssuer());
        }
        SAML2AssertionValidator.verifySignature(assertion.getSignature(), key);
        return assertion;
    }

    public Assertion validate(String xml, Issuer expectedIssuer, Key key) throws BadSAML2AssertionException {
        Assertion assertion;
        try {
            assertion = SAML2AssertionValidator.parse(xml);
        }
        catch (ParseException e) {
            throw new BadSAML2AssertionException("Invalid SAML 2.0 assertion: " + e.getMessage(), e);
        }
        return this.validate(assertion, expectedIssuer, key);
    }

    static {
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

