/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.token.verifiers;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.JWTClaimsVerifier;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.Nonce;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class IDTokenClaimsVerifier
implements JWTClaimsVerifier {
    private static final BadJWTException MISSING_EXP_CLAIM_EXCEPTION = new BadJWTException("Missing JWT expiration (exp) claim");
    private static final BadJWTException MISSING_IAT_CLAIM_EXCEPTION = new BadJWTException("Missing JWT issue time (iat) claim");
    private static final BadJWTException MISSING_ISS_CLAIM_EXCEPTION = new BadJWTException("Missing JWT issuer (iss) claim");
    private static final BadJWTException MISSING_SUB_CLAIM_EXCEPTION = new BadJWTException("Missing JWT subject (sub) claim");
    private static final BadJWTException MISSING_AUD_CLAIM_EXCEPTION = new BadJWTException("Missing JWT audience (aud) claim");
    private static final BadJWTException MISSING_NONCE_CLAIM_EXCEPTION = new BadJWTException("Missing JWT nonce (nonce) claim");
    private static final BadJWTException EXPIRED_EXCEPTION = new BadJWTException("Expired JWT");
    private static final BadJWTException IAT_CLAIM_AHEAD_EXCEPTION = new BadJWTException("JWT issue time ahead of current time");
    private final Issuer expectedIssuer;
    private final ClientID expectedClientID;
    private final Nonce expectedNonce;

    public IDTokenClaimsVerifier(Issuer issuer, ClientID clientID, Nonce nonce) {
        if (issuer == null) {
            throw new IllegalArgumentException("The expected ID token issuer must not be null");
        }
        this.expectedIssuer = issuer;
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.expectedClientID = clientID;
        this.expectedNonce = nonce;
    }

    public Issuer getExpectedIssuer() {
        return this.expectedIssuer;
    }

    public ClientID getClientID() {
        return this.expectedClientID;
    }

    public Nonce getExpectedNonce() {
        return this.expectedNonce;
    }

    public void verify(JWTClaimsSet claimsSet) throws BadJWTException {
        Date exp;
        String tokenIssuer = claimsSet.getIssuer();
        if (tokenIssuer == null) {
            throw MISSING_ISS_CLAIM_EXCEPTION;
        }
        if (!this.expectedIssuer.getValue().equals(tokenIssuer)) {
            throw new BadJWTException("Unexpected JWT issuer: " + tokenIssuer);
        }
        if (claimsSet.getSubject() == null) {
            throw MISSING_SUB_CLAIM_EXCEPTION;
        }
        List tokenAudience = claimsSet.getAudience();
        if (tokenAudience == null || tokenAudience.isEmpty()) {
            throw MISSING_AUD_CLAIM_EXCEPTION;
        }
        if (!tokenAudience.contains(this.expectedClientID.getValue())) {
            throw new BadJWTException("Unexpected JWT audience: " + tokenAudience);
        }
        if (tokenAudience.size() > 1) {
            String tokenAzp;
            try {
                tokenAzp = claimsSet.getStringClaim("azp");
            }
            catch (ParseException e) {
                throw new BadJWTException("Invalid JWT authorized party (azp) claim: " + e.getMessage());
            }
            if (tokenAzp != null && !this.expectedClientID.getValue().equals(tokenAzp)) {
                throw new BadJWTException("Unexpected JWT authorized party (azp) claim: " + tokenAzp);
            }
        }
        if ((exp = claimsSet.getExpirationTime()) == null) {
            throw MISSING_EXP_CLAIM_EXCEPTION;
        }
        Date iat = claimsSet.getIssueTime();
        if (iat == null) {
            throw MISSING_IAT_CLAIM_EXCEPTION;
        }
        Date now = new Date();
        if (exp.before(now)) {
            throw EXPIRED_EXCEPTION;
        }
        if (iat.after(now)) {
            throw IAT_CLAIM_AHEAD_EXCEPTION;
        }
        if (this.expectedNonce != null) {
            String tokenNonce;
            try {
                tokenNonce = claimsSet.getStringClaim("nonce");
            }
            catch (ParseException e) {
                throw new BadJWTException("Invalid JWT nonce (nonce) claim: " + e.getMessage());
            }
            if (tokenNonce == null) {
                throw MISSING_NONCE_CLAIM_EXCEPTION;
            }
            if (!this.expectedNonce.getValue().equals(tokenNonce)) {
                throw new BadJWTException("Unexpected JWT nonce (nonce) claim: " + tokenNonce);
            }
        }
    }
}

