/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.auth.verifier;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.oauth2.sdk.assertions.jwt.JWTAssertionClaimsSetVerifier;
import com.nimbusds.oauth2.sdk.id.Audience;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
class JWTAuthenticationClaimsSetVerifier
extends JWTAssertionClaimsSetVerifier {
    private static BadJWTException ISS_SUB_MISMATCH_EXCEPTION = new BadJWTException("Issuer and subject JWT claims don't match");

    public JWTAuthenticationClaimsSetVerifier(Set<Audience> expectedAudience) {
        super(expectedAudience);
    }

    @Override
    public void verify(JWTClaimsSet claimsSet) throws BadJWTException {
        super.verify(claimsSet);
        if (!claimsSet.getIssuer().equals(claimsSet.getSubject())) {
            throw ISS_SUB_MISMATCH_EXCEPTION;
        }
    }
}

