/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.assertions.jwt;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.util.DateUtils;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.JWTID;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONObject;

public class JWTAssertionClaimsSet {
    private static final Set<String> reservedClaimsNames = new LinkedHashSet<String>();
    private final Issuer iss;
    private final Subject sub;
    private final List<Audience> aud;
    private final Date exp;
    private final Date nbf;
    private final Date iat;
    private final JWTID jti;
    private final Map<String, Object> other;

    public static Set<String> getReservedClaimsNames() {
        return Collections.unmodifiableSet(reservedClaimsNames);
    }

    public JWTAssertionClaimsSet(Issuer iss, Subject sub, Audience aud) {
        this(iss, sub, aud.toSingleAudienceList(), new Date(new Date().getTime() + 300000L), null, null, new JWTID(), null);
    }

    public JWTAssertionClaimsSet(Issuer iss, Subject sub, List<Audience> aud, Date exp, Date nbf, Date iat, JWTID jti, Map<String, Object> other) {
        if (iss == null) {
            throw new IllegalArgumentException("The issuer must not be null");
        }
        this.iss = iss;
        if (sub == null) {
            throw new IllegalArgumentException("The subject must not be null");
        }
        this.sub = sub;
        if (aud == null || aud.isEmpty()) {
            throw new IllegalArgumentException("The audience must not be null or empty");
        }
        this.aud = aud;
        if (exp == null) {
            throw new IllegalArgumentException("The expiration time must not be null");
        }
        this.exp = exp;
        this.nbf = nbf;
        this.iat = iat;
        this.jti = jti;
        this.other = other;
    }

    public Issuer getIssuer() {
        return this.iss;
    }

    public Subject getSubject() {
        return this.sub;
    }

    public List<Audience> getAudience() {
        return this.aud;
    }

    public Date getExpirationTime() {
        return this.exp;
    }

    public Date getNotBeforeTime() {
        return this.nbf;
    }

    public Date getIssueTime() {
        return this.iat;
    }

    public JWTID getJWTID() {
        return this.jti;
    }

    public Map<String, Object> getCustomClaims() {
        return this.other;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        o.put((Object)"iss", (Object)this.iss.getValue());
        o.put((Object)"sub", (Object)this.sub.getValue());
        o.put((Object)"aud", Audience.toStringList(this.aud));
        o.put((Object)"exp", (Object)DateUtils.toSecondsSinceEpoch((Date)this.exp));
        if (this.nbf != null) {
            o.put((Object)"nbf", (Object)DateUtils.toSecondsSinceEpoch((Date)this.nbf));
        }
        if (this.iat != null) {
            o.put((Object)"iat", (Object)DateUtils.toSecondsSinceEpoch((Date)this.iat));
        }
        if (this.jti != null) {
            o.put((Object)"jti", (Object)this.jti.getValue());
        }
        if (this.other != null) {
            o.putAll(this.other);
        }
        return o;
    }

    public JWTClaimsSet toJWTClaimsSet() {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().issuer(this.iss.getValue()).subject(this.sub.getValue()).audience(Audience.toStringList(this.aud)).expirationTime(this.exp).notBeforeTime(this.nbf).issueTime(this.iat).jwtID(this.jti != null ? this.jti.getValue() : null);
        if (this.other != null) {
            for (Map.Entry<String, Object> entry : this.other.entrySet()) {
                builder = builder.claim(entry.getKey(), entry.getValue());
            }
        }
        return builder.build();
    }

    public static JWTAssertionClaimsSet parse(JSONObject jsonObject) throws ParseException {
        Issuer iss = new Issuer(JSONObjectUtils.getString(jsonObject, "iss"));
        Subject sub = new Subject(JSONObjectUtils.getString(jsonObject, "sub"));
        List<Audience> aud = jsonObject.get((Object)"aud") instanceof String ? new Audience(JSONObjectUtils.getString(jsonObject, "aud")).toSingleAudienceList() : Audience.create(JSONObjectUtils.getStringList(jsonObject, "aud"));
        Date exp = DateUtils.fromSecondsSinceEpoch((long)JSONObjectUtils.getLong(jsonObject, "exp"));
        Date nbf = null;
        if (jsonObject.containsKey((Object)"nbf")) {
            nbf = DateUtils.fromSecondsSinceEpoch((long)JSONObjectUtils.getLong(jsonObject, "nbf"));
        }
        Date iat = null;
        if (jsonObject.containsKey((Object)"iat")) {
            iat = DateUtils.fromSecondsSinceEpoch((long)JSONObjectUtils.getLong(jsonObject, "iat"));
        }
        JWTID jti = null;
        if (jsonObject.containsKey((Object)"jti")) {
            jti = new JWTID(JSONObjectUtils.getString(jsonObject, "jti"));
        }
        LinkedHashMap<String, Object> other = null;
        Set customClaimNames = jsonObject.keySet();
        if (customClaimNames.removeAll(reservedClaimsNames)) {
            other = new LinkedHashMap<String, Object>();
            for (String claim : customClaimNames) {
                other.put(claim, jsonObject.get((Object)claim));
            }
        }
        return new JWTAssertionClaimsSet(iss, sub, aud, exp, nbf, iat, jti, other);
    }

    public static JWTAssertionClaimsSet parse(JWTClaimsSet jwtClaimsSet) throws ParseException {
        return JWTAssertionClaimsSet.parse(jwtClaimsSet.toJSONObject());
    }

    static {
        reservedClaimsNames.add("iss");
        reservedClaimsNames.add("sub");
        reservedClaimsNames.add("aud");
        reservedClaimsNames.add("exp");
        reservedClaimsNames.add("nbf");
        reservedClaimsNames.add("iat");
        reservedClaimsNames.add("jti");
    }
}

