/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.net.URI;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class ErrorObject {
    private final String code;
    private final String description;
    private final int httpStatusCode;
    private final URI uri;

    public ErrorObject(String code) {
        this(code, null, 0, null);
    }

    public ErrorObject(String code, String description) {
        this(code, description, 0, null);
    }

    public ErrorObject(String code, String description, int httpStatusCode) {
        this(code, description, httpStatusCode, null);
    }

    public ErrorObject(String code, String description, int httpStatusCode, URI uri) {
        this.code = code;
        this.description = description;
        this.httpStatusCode = httpStatusCode;
        this.uri = uri;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public ErrorObject setDescription(String description) {
        return new ErrorObject(this.getCode(), description, this.getHTTPStatusCode(), this.getURI());
    }

    public ErrorObject appendDescription(String text) {
        String newDescription = this.getDescription() != null ? this.getDescription() + text : text;
        return new ErrorObject(this.getCode(), newDescription, this.getHTTPStatusCode(), this.getURI());
    }

    public int getHTTPStatusCode() {
        return this.httpStatusCode;
    }

    public ErrorObject setHTTPStatusCode(int httpStatusCode) {
        return new ErrorObject(this.getCode(), this.getDescription(), httpStatusCode, this.getURI());
    }

    public URI getURI() {
        return this.uri;
    }

    public ErrorObject setURI(URI uri) {
        return new ErrorObject(this.getCode(), this.getDescription(), this.getHTTPStatusCode(), uri);
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        if (this.code != null) {
            o.put((Object)"error", (Object)this.code);
        }
        if (this.description != null) {
            o.put((Object)"error_description", (Object)this.description);
        }
        if (this.uri != null) {
            o.put((Object)"error_uri", (Object)this.uri.toString());
        }
        return o;
    }

    public String toString() {
        return this.code != null ? this.code : "null";
    }

    public int hashCode() {
        return this.code != null ? this.code.hashCode() : "null".hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ErrorObject && this.toString().equals(object.toString());
    }

    public static ErrorObject parse(JSONObject jsonObject) {
        String code = null;
        String description = null;
        URI uri = null;
        try {
            if (jsonObject.containsKey((Object)"error")) {
                code = JSONObjectUtils.getString(jsonObject, "error");
            }
            if (jsonObject.containsKey((Object)"error_description")) {
                description = JSONObjectUtils.getString(jsonObject, "error_description");
            }
            if (jsonObject.containsKey((Object)"error_uri")) {
                uri = JSONObjectUtils.getURI(jsonObject, "error_uri");
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return new ErrorObject(code, description, 0, uri);
    }

    public static ErrorObject parse(HTTPResponse httpResponse) {
        JSONObject jsonObject;
        try {
            jsonObject = httpResponse.getContentAsJSONObject();
        }
        catch (ParseException e) {
            return new ErrorObject(null, null, httpResponse.getStatusCode());
        }
        ErrorObject intermediary = ErrorObject.parse(jsonObject);
        return new ErrorObject(intermediary.getCode(), intermediary.description, httpResponse.getStatusCode(), intermediary.getURI());
    }
}

