/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.rp;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.client.ClientRegistrationRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class OIDCClientRegistrationRequest
extends ClientRegistrationRequest {
    public OIDCClientRegistrationRequest(URI uri, OIDCClientMetadata metadata, BearerAccessToken accessToken) {
        super(uri, metadata, accessToken);
    }

    public OIDCClientMetadata getOIDCClientMetadata() {
        return (OIDCClientMetadata)this.getClientMetadata();
    }

    public static OIDCClientRegistrationRequest parse(HTTPRequest httpRequest) throws ParseException {
        URI endpointURI;
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        JSONObject jsonObject = httpRequest.getQueryAsJSONObject();
        OIDCClientMetadata metadata = OIDCClientMetadata.parse(jsonObject);
        BearerAccessToken accessToken = null;
        String authzHeaderValue = httpRequest.getAuthorization();
        if (StringUtils.isNotBlank((CharSequence)authzHeaderValue)) {
            accessToken = BearerAccessToken.parse(authzHeaderValue);
        }
        try {
            endpointURI = httpRequest.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), e);
        }
        return new OIDCClientRegistrationRequest(endpointURI, metadata, accessToken);
    }
}

