/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk.client;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class ClientInformation {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final ClientID id;
    private final URI registrationURI;
    private final BearerAccessToken accessToken;
    private final ClientMetadata metadata;
    private final Secret secret;
    private final Date issueDate;

    public ClientInformation(ClientID id, URI registrationURI, BearerAccessToken accessToken, ClientMetadata metadata, Secret secret, Date issueDate) {
        if (id == null) {
            throw new IllegalArgumentException("The client identifier must not be null");
        }
        this.id = id;
        if (registrationURI == null) {
            throw new IllegalArgumentException("The client registration URI must not be null");
        }
        this.registrationURI = registrationURI;
        if (accessToken == null) {
            throw new IllegalArgumentException("The client registration access token must not be null");
        }
        this.accessToken = accessToken;
        if (metadata == null) {
            throw new IllegalArgumentException("The client metadata must not be null");
        }
        this.metadata = metadata;
        this.secret = secret;
        this.issueDate = issueDate;
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public ClientID getID() {
        return this.id;
    }

    public URI getRegistrationURI() {
        return this.registrationURI;
    }

    public BearerAccessToken getRegistrationAccessToken() {
        return this.accessToken;
    }

    public ClientMetadata getClientMetadata() {
        return this.metadata;
    }

    public Secret getSecret() {
        return this.secret;
    }

    public Date getIssueDate() {
        return this.issueDate;
    }

    public JSONObject toJSONObject() {
        JSONObject o = this.metadata.toJSONObject();
        o.put((Object)"client_id", (Object)this.id.getValue());
        o.put((Object)"registration_client_uri", (Object)this.registrationURI.toString());
        o.put((Object)"registration_access_token", (Object)this.accessToken.getValue());
        if (this.secret != null) {
            o.put((Object)"client_secret", (Object)this.secret.getValue());
            if (this.secret.getExpirationDate() != null) {
                o.put((Object)"client_secret_expires_at", (Object)(this.secret.getExpirationDate().getTime() / 1000L));
            }
        }
        if (this.issueDate != null) {
            o.put((Object)"client_id_issued_at", (Object)(this.issueDate.getTime() / 1000L));
        }
        return o;
    }

    public static ClientInformation parse(JSONObject jsonObject) throws ParseException {
        ClientID id = new ClientID(JSONObjectUtils.getString(jsonObject, "client_id"));
        URI registrationURI = JSONObjectUtils.getURI(jsonObject, "registration_client_uri");
        BearerAccessToken accessToken = new BearerAccessToken(JSONObjectUtils.getString(jsonObject, "registration_access_token"));
        ClientMetadata metadata = ClientMetadata.parse(jsonObject);
        Secret secret = null;
        if (jsonObject.containsKey((Object)"client_secret")) {
            String value = JSONObjectUtils.getString(jsonObject, "client_secret");
            Date exp = null;
            if (jsonObject.containsKey((Object)"client_secret_expires_at")) {
                exp = new Date(JSONObjectUtils.getLong(jsonObject, "client_secret_expires_at") * 1000L);
            }
            secret = new Secret(value, exp);
        }
        Date issueDate = null;
        if (jsonObject.containsKey((Object)"client_id_issued_at")) {
            issueDate = new Date(JSONObjectUtils.getLong(jsonObject, "client_id_issued_at") * 1000L);
        }
        return new ClientInformation(id, registrationURI, accessToken, metadata, secret, issueDate);
    }

    static {
        HashSet<String> p = new HashSet<String>(ClientMetadata.getRegisteredParameterNames());
        p.add("client_id");
        p.add("client_id_issued_at");
        p.add("registration_access_token");
        p.add("registration_client_uri");
        p.add("client_secret");
        p.add("client_secret_expires_at");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(p);
    }
}

