/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import java.net.URI;
import net.jcip.annotations.Immutable;

@Immutable
public class ErrorObject {
    private final String code;
    private final String description;
    private final int httpStatusCode;
    private final URI uri;

    public ErrorObject(String code) {
        this(code, null, 0, null);
    }

    public ErrorObject(String code, String description) {
        this(code, description, 0, null);
    }

    public ErrorObject(String code, String description, int httpStatusCode) {
        this(code, description, httpStatusCode, null);
    }

    public ErrorObject(String code, String description, int httpStatusCode, URI uri) {
        this.code = code;
        this.description = description;
        this.httpStatusCode = httpStatusCode;
        this.uri = uri;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public ErrorObject setDescription(String description) {
        return new ErrorObject(this.getCode(), description, this.getHTTPStatusCode(), this.getURI());
    }

    public ErrorObject appendDescription(String text) {
        String newDescription = this.getDescription() != null ? this.getDescription() + text : text;
        return new ErrorObject(this.getCode(), newDescription, this.getHTTPStatusCode(), this.getURI());
    }

    public int getHTTPStatusCode() {
        return this.httpStatusCode;
    }

    public ErrorObject setHTTPStatusCode(int httpStatusCode) {
        return new ErrorObject(this.getCode(), this.getDescription(), httpStatusCode, this.getURI());
    }

    public URI getURI() {
        return this.uri;
    }

    public ErrorObject setURI(URI uri) {
        return new ErrorObject(this.getCode(), this.getDescription(), this.getHTTPStatusCode(), uri);
    }

    public String toString() {
        if (this.code != null) {
            return this.code;
        }
        return "null";
    }

    public int hashCode() {
        if (this.code != null) {
            return this.code.hashCode();
        }
        return "null".hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ErrorObject && this.toString().equals(object.toString());
    }
}

