/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AbstractRequest;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.util.URIUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class AuthorizationRequest
extends AbstractRequest {
    private final ResponseType rt;
    private final ClientID clientID;
    private final URI redirectURI;
    private final Scope scope;
    private final State state;

    public AuthorizationRequest(URI uri, ResponseType rt, ClientID clientID) {
        this(uri, rt, clientID, null, null, null);
    }

    public AuthorizationRequest(URI uri, ResponseType rt, ClientID clientID, URI redirectURI, Scope scope, State state) {
        super(uri);
        if (rt == null) {
            throw new IllegalArgumentException("The response type must not be null");
        }
        this.rt = rt;
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.clientID = clientID;
        this.redirectURI = redirectURI;
        this.scope = scope;
        this.state = state;
    }

    public ResponseType getResponseType() {
        return this.rt;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public URI getRedirectionURI() {
        return this.redirectURI;
    }

    public Scope getScope() {
        return this.scope;
    }

    public State getState() {
        return this.state;
    }

    public Map<String, String> toParameters() throws SerializeException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("response_type", this.rt.toString());
        params.put("client_id", this.clientID.getValue());
        if (this.redirectURI != null) {
            params.put("redirect_uri", this.redirectURI.toString());
        }
        if (this.scope != null) {
            params.put("scope", this.scope.toString());
        }
        if (this.state != null) {
            params.put("state", this.state.getValue());
        }
        return params;
    }

    public String toQueryString() throws SerializeException {
        return URLUtils.serializeParameters(this.toParameters());
    }

    public URI toURI() throws SerializeException {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The authorization endpoint URI is not specified");
        }
        StringBuilder sb = new StringBuilder(this.getEndpointURI().toString());
        sb.append('?');
        sb.append(this.toQueryString());
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new SerializeException("Couldn't append query string: " + e.getMessage(), e);
        }
    }

    public HTTPRequest toHTTPRequest(HTTPRequest.Method method) throws SerializeException {
        HTTPRequest httpRequest;
        URL endpointURL;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        try {
            endpointURL = this.getEndpointURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new SerializeException(e.getMessage(), e);
        }
        if (method.equals((Object)HTTPRequest.Method.GET)) {
            httpRequest = new HTTPRequest(HTTPRequest.Method.GET, endpointURL);
        } else if (method.equals((Object)HTTPRequest.Method.POST)) {
            httpRequest = new HTTPRequest(HTTPRequest.Method.POST, endpointURL);
        } else {
            throw new IllegalArgumentException("The HTTP request method must be GET or POST");
        }
        httpRequest.setQuery(this.toQueryString());
        return httpRequest;
    }

    @Override
    public HTTPRequest toHTTPRequest() throws SerializeException {
        return this.toHTTPRequest(HTTPRequest.Method.GET);
    }

    public static AuthorizationRequest parse(Map<String, String> params) throws ParseException {
        return AuthorizationRequest.parse(null, params);
    }

    public static AuthorizationRequest parse(URI uri, Map<String, String> params) throws ParseException {
        ResponseType rt;
        String v = params.get("client_id");
        if (StringUtils.isBlank((CharSequence)v)) {
            throw new ParseException("Missing \"client_id\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        ClientID clientID = new ClientID(v);
        v = params.get("redirect_uri");
        URI redirectURI = null;
        if (StringUtils.isNotBlank((CharSequence)v)) {
            try {
                redirectURI = new URI(v);
            }
            catch (URISyntaxException e) {
                throw new ParseException("Invalid \"redirect_uri\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, clientID, null, null, e);
            }
        }
        State state = State.parse(params.get("state"));
        v = params.get("response_type");
        try {
            rt = ResponseType.parse(v);
        }
        catch (ParseException e) {
            throw new ParseException(e.getMessage(), OAuth2Error.UNSUPPORTED_RESPONSE_TYPE, clientID, redirectURI, state, e);
        }
        v = params.get("scope");
        Scope scope = null;
        if (StringUtils.isNotBlank((CharSequence)v)) {
            scope = Scope.parse(v);
        }
        return new AuthorizationRequest(uri, rt, clientID, redirectURI, scope, state);
    }

    public static AuthorizationRequest parse(String query) throws ParseException {
        return AuthorizationRequest.parse(null, URLUtils.parseParameters(query));
    }

    public static AuthorizationRequest parse(URI uri, String query) throws ParseException {
        return AuthorizationRequest.parse(uri, URLUtils.parseParameters(query));
    }

    public static AuthorizationRequest parse(URI uri) throws ParseException {
        URI endpointURI;
        StringBuilder sb = new StringBuilder(uri.getScheme());
        sb.append("://");
        if (uri.getHost() != null) {
            sb.append(uri.getHost());
        }
        if (uri.getPort() > 0) {
            sb.append(':');
            sb.append(uri.getPort());
        }
        if (uri.getPath() != null) {
            sb.append(uri.getPath());
        }
        try {
            endpointURI = new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new ParseException("Couldn't parse endpoint URI: " + e.getMessage(), e);
        }
        return AuthorizationRequest.parse(endpointURI, URLUtils.parseParameters(uri.getQuery()));
    }

    public static AuthorizationRequest parse(HTTPRequest httpRequest) throws ParseException {
        String query = httpRequest.getQuery();
        if (query == null) {
            throw new ParseException("Missing URI query string");
        }
        try {
            return AuthorizationRequest.parse(URIUtils.getBaseURI(httpRequest.getURL().toURI()), query);
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), e);
        }
    }

    public static class Builder {
        private URI uri;
        private final ResponseType rt;
        private final ClientID clientID;
        private URI redirectURI;
        private Scope scope;
        private State state;

        public Builder(ResponseType rt, ClientID clientID) {
            if (rt == null) {
                throw new IllegalArgumentException("The response type must not be null");
            }
            this.rt = rt;
            if (clientID == null) {
                throw new IllegalArgumentException("The client ID must not be null");
            }
            this.clientID = clientID;
        }

        public Builder redirectionURI(URI redirectURI) {
            this.redirectURI = redirectURI;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder endpointURI(URI uri) {
            this.uri = uri;
            return this;
        }

        public AuthorizationRequest build() {
            return new AuthorizationRequest(this.uri, this.rt, this.clientID, this.redirectURI, this.scope, this.state);
        }
    }
}

