/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public final class AuthorizationCodeGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.AUTHORIZATION_CODE;
    private final AuthorizationCode code;
    private final URI redirectURI;
    private final ClientID clientID;

    public AuthorizationCodeGrant(AuthorizationCode code, URI redirectURI) {
        super(GRANT_TYPE);
        if (code == null) {
            throw new IllegalArgumentException("The authorisation code must not be null");
        }
        this.code = code;
        this.redirectURI = redirectURI;
        this.clientID = null;
    }

    public AuthorizationCodeGrant(AuthorizationCode code, URI redirectURI, ClientID clientID) {
        super(GrantType.AUTHORIZATION_CODE);
        if (code == null) {
            throw new IllegalArgumentException("The authorisation code must not be null");
        }
        this.code = code;
        this.redirectURI = redirectURI;
        if (clientID == null) {
            throw new IllegalArgumentException("The client identifier must not be null");
        }
        this.clientID = clientID;
    }

    public AuthorizationCode getAuthorizationCode() {
        return this.code;
    }

    public URI getRedirectionURI() {
        return this.redirectURI;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    @Override
    public Map<String, String> toParameters() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("grant_type", GRANT_TYPE.getValue());
        params.put("code", this.code.getValue());
        if (this.redirectURI != null) {
            params.put("redirect_uri", this.redirectURI.toString());
        }
        if (this.clientID != null) {
            params.put("client_id", this.clientID.getValue());
        }
        return params;
    }

    public static AuthorizationCodeGrant parse(Map<String, String> params) throws ParseException {
        String grantTypeString = params.get("grant_type");
        if (grantTypeString == null) {
            throw new ParseException("Missing \"grant_type\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        GrantType grantType = new GrantType(grantTypeString);
        if (!grantType.equals(GRANT_TYPE)) {
            throw new ParseException("The \"grant_type\" must be " + GRANT_TYPE, OAuth2Error.INVALID_GRANT);
        }
        String codeString = params.get("code");
        if (codeString == null || codeString.trim().isEmpty()) {
            throw new ParseException("Missing or empty \"code\" parameter", OAuth2Error.INVALID_REQUEST);
        }
        AuthorizationCode code = new AuthorizationCode(codeString);
        String redirectURIString = params.get("redirect_uri");
        URI redirectURI = null;
        if (redirectURIString != null) {
            try {
                redirectURI = new URI(redirectURIString);
            }
            catch (URISyntaxException e) {
                throw new ParseException("Invalid \"redirect_uri\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, e);
            }
        }
        String clientIDString = params.get("client_id");
        ClientID clientID = null;
        if (clientIDString != null && clientIDString.trim().length() > 0) {
            clientID = new ClientID(clientIDString);
        }
        if (clientID == null) {
            return new AuthorizationCodeGrant(code, redirectURI);
        }
        return new AuthorizationCodeGrant(code, redirectURI, clientID);
    }
}

