/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.SuccessResponse;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.http.CommonContentTypes;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.TokenPair;
import java.util.Map;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public class AccessTokenResponse
extends TokenResponse
implements SuccessResponse {
    private final AccessToken accessToken;
    private final RefreshToken refreshToken;

    public AccessTokenResponse(AccessToken accessToken, RefreshToken refreshToken) {
        if (accessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public AccessTokenResponse(TokenPair tokenPair) {
        this(tokenPair.getAccessToken(), tokenPair.getRefreshToken());
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public TokenPair getTokenPair() {
        return new TokenPair(this.accessToken, this.refreshToken);
    }

    public JSONObject toJSONObject() throws SerializeException {
        JSONObject o = this.accessToken.toJSONObject();
        if (this.refreshToken != null) {
            o.putAll((Map)this.refreshToken.toJSONObject());
        }
        return o;
    }

    @Override
    public HTTPResponse toHTTPResponse() throws SerializeException {
        HTTPResponse httpResponse = new HTTPResponse(200);
        httpResponse.setContentType(CommonContentTypes.APPLICATION_JSON);
        httpResponse.setCacheControl("no-store");
        httpResponse.setPragma("no-cache");
        httpResponse.setContent(this.toJSONObject().toString());
        return httpResponse;
    }

    public static AccessTokenResponse parse(JSONObject jsonObject) throws ParseException {
        AccessToken accessToken = AccessToken.parse(jsonObject);
        RefreshToken refreshToken = RefreshToken.parse(jsonObject);
        return new AccessTokenResponse(accessToken, refreshToken);
    }

    public static AccessTokenResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(200);
        JSONObject jsonObject = httpResponse.getContentAsJSONObject();
        return AccessTokenResponse.parse(jsonObject);
    }
}

