/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.util;

import com.nimbusds.openid.connect.sdk.util.Resource;
import com.nimbusds.openid.connect.sdk.util.ResourceRetriever;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultResourceRetriever
implements ResourceRetriever {
    private final String lineSeparator;
    private int connectTimeout;
    private int readTimeout;

    public DefaultResourceRetriever() {
        this(0, 0);
    }

    public DefaultResourceRetriever(int connectTimeout, int readTimeout) {
        this.setConnectTimeout(connectTimeout);
        this.setReadTimeout(readTimeout);
        this.lineSeparator = System.getProperty("line.separator");
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("The connect timeout must not be negative");
        }
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        if (readTimeout < 0) {
            throw new IllegalArgumentException("The read timeout must not be negative");
        }
        this.readTimeout = readTimeout;
    }

    @Override
    public Resource retrieveResource(URL url) throws IOException {
        HttpURLConnection con;
        try {
            con = (HttpURLConnection)url.openConnection();
        }
        catch (ClassCastException e) {
            throw new IOException("Couldn't open HTTP(S) connection: " + e.getMessage(), e);
        }
        con.setConnectTimeout(this.connectTimeout);
        con.setReadTimeout(this.readTimeout);
        StringBuilder sb = new StringBuilder();
        BufferedReader input = new BufferedReader(new InputStreamReader(con.getInputStream()));
        String line = null;
        while ((line = input.readLine()) != null) {
            sb.append(line);
            sb.append(this.lineSeparator);
        }
        input.close();
        int statusCode = con.getResponseCode();
        String statusMessage = con.getResponseMessage();
        if (statusCode != 200) {
            throw new IOException("HTTP " + statusCode + ": " + statusMessage);
        }
        ContentType contentType = null;
        if (con.getContentType() != null) {
            try {
                contentType = new ContentType(con.getContentType());
            }
            catch (ParseException e) {
                throw new IOException("Couldn't parse Content-Type header: " + e.getMessage(), e);
            }
        }
        return new Resource(sb.toString(), contentType);
    }
}

