/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagException;
import com.nimbusds.oauth2.sdk.AuthorizationRequest;
import com.nimbusds.oauth2.sdk.OAuth2Error;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.oauth2.sdk.util.URLUtils;
import com.nimbusds.openid.connect.sdk.ClaimsRequest;
import com.nimbusds.openid.connect.sdk.Display;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCResponseTypeValidator;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import com.nimbusds.openid.connect.sdk.Prompt;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

@Immutable
public final class OIDCAuthorizationRequest
extends AuthorizationRequest {
    private final Nonce nonce;
    private final Display display;
    private final Prompt prompt;
    private final int maxAge;
    private final List<LangTag> uiLocales;
    private final List<LangTag> claimsLocales;
    private final JWT idTokenHint;
    private final String loginHint;
    private final List<ACR> acrValues;
    private final ClaimsRequest claims;
    private final JWT requestObject;
    private final URL requestURI;

    public OIDCAuthorizationRequest(URL uri, ResponseType rt, Scope scope, ClientID clientID, URL redirectURI, State state, Nonce nonce) {
        this(uri, rt, scope, clientID, redirectURI, state, nonce, null, null, 0, null, null, null, null, null, null);
    }

    public OIDCAuthorizationRequest(URL uri, ResponseType rt, Scope scope, ClientID clientID, URL redirectURI, State state, Nonce nonce, Display display, Prompt prompt, int maxAge, List<LangTag> uiLocales, List<LangTag> claimsLocales, JWT idTokenHint, String loginHint, List<ACR> acrValues, ClaimsRequest claims) {
        this(uri, rt, scope, clientID, redirectURI, state, nonce, display, prompt, maxAge, uiLocales, claimsLocales, idTokenHint, loginHint, acrValues, claims, (JWT)null);
    }

    public OIDCAuthorizationRequest(URL uri, ResponseType rt, Scope scope, ClientID clientID, URL redirectURI, State state, Nonce nonce, Display display, Prompt prompt, int maxAge, List<LangTag> uiLocales, List<LangTag> claimsLocales, JWT idTokenHint, String loginHint, List<ACR> acrValues, ClaimsRequest claims, JWT requestObject) {
        super(uri, rt, clientID, redirectURI, scope, state);
        if (redirectURI == null) {
            throw new IllegalArgumentException("The redirect URI must not be null");
        }
        OIDCResponseTypeValidator.validate(rt);
        if (scope == null) {
            throw new IllegalArgumentException("The scope must not be null");
        }
        if (!scope.contains(OIDCScopeValue.OPENID)) {
            throw new IllegalArgumentException("The scope must include an \"openid\" token");
        }
        if (rt.impliesImplicitFlow() && nonce == null) {
            throw new IllegalArgumentException("Nonce is required in implicit protocol flow");
        }
        this.nonce = nonce;
        this.display = display;
        this.prompt = prompt;
        this.maxAge = maxAge;
        this.uiLocales = uiLocales != null ? Collections.unmodifiableList(uiLocales) : null;
        this.claimsLocales = claimsLocales != null ? Collections.unmodifiableList(claimsLocales) : null;
        this.idTokenHint = idTokenHint;
        this.loginHint = loginHint;
        this.acrValues = acrValues != null ? Collections.unmodifiableList(acrValues) : null;
        this.claims = claims;
        this.requestObject = requestObject;
        this.requestURI = null;
    }

    public OIDCAuthorizationRequest(URL uri, ResponseType rt, Scope scope, ClientID clientID, URL redirectURI, State state, Nonce nonce, Display display, Prompt prompt, int maxAge, List<LangTag> uiLocales, List<LangTag> claimsLocales, JWT idTokenHint, String loginHint, List<ACR> acrValues, ClaimsRequest claims, URL requestURI) {
        super(uri, rt, clientID, redirectURI, scope, state);
        if (redirectURI == null) {
            throw new IllegalArgumentException("The redirect URI must not be null");
        }
        OIDCResponseTypeValidator.validate(rt);
        if (scope == null) {
            throw new IllegalArgumentException("The scope must not be null");
        }
        if (!scope.contains(OIDCScopeValue.OPENID)) {
            throw new IllegalArgumentException("The scope must include an \"openid\" token");
        }
        if (rt.impliesImplicitFlow() && nonce == null) {
            throw new IllegalArgumentException("Nonce is required in implicit protocol flow");
        }
        this.nonce = nonce;
        this.display = display;
        this.prompt = prompt;
        this.maxAge = maxAge;
        this.uiLocales = uiLocales != null ? Collections.unmodifiableList(uiLocales) : null;
        this.claimsLocales = claimsLocales != null ? Collections.unmodifiableList(claimsLocales) : null;
        this.idTokenHint = idTokenHint;
        this.loginHint = loginHint;
        this.acrValues = acrValues != null ? Collections.unmodifiableList(acrValues) : null;
        this.claims = claims;
        this.requestObject = null;
        this.requestURI = requestURI;
    }

    public Nonce getNonce() {
        return this.nonce;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public List<LangTag> getUILocales() {
        return this.uiLocales;
    }

    public List<LangTag> getClaimsLocales() {
        return this.claimsLocales;
    }

    public JWT getIDTokenHint() {
        return this.idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public List<ACR> getACRValues() {
        return this.acrValues;
    }

    public ClaimsRequest getClaims() {
        return this.claims;
    }

    public JWT getRequestObject() {
        return this.requestObject;
    }

    public URL getRequestURI() {
        return this.requestURI;
    }

    public boolean specifiesRequestObject() {
        return this.requestObject != null || this.requestURI != null;
    }

    @Override
    public Map<String, String> toParameters() throws SerializeException {
        StringBuilder sb;
        Map<String, String> params = super.toParameters();
        if (this.nonce != null) {
            params.put("nonce", this.nonce.toString());
        }
        if (this.display != null) {
            params.put("display", this.display.toString());
        }
        if (this.prompt != null) {
            params.put("prompt", this.prompt.toString());
        }
        if (this.maxAge > 0) {
            params.put("max_age", "" + this.maxAge);
        }
        if (this.uiLocales != null) {
            sb = new StringBuilder();
            for (LangTag locale : this.uiLocales) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(locale.toString());
            }
            params.put("ui_locales", sb.toString());
        }
        if (this.claimsLocales != null) {
            sb = new StringBuilder();
            for (LangTag locale : this.claimsLocales) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(locale.toString());
            }
            params.put("claims_locales", sb.toString());
        }
        if (this.idTokenHint != null) {
            try {
                params.put("id_token_hint", this.idTokenHint.serialize());
            }
            catch (IllegalStateException e) {
                throw new SerializeException("Couldn't serialize ID token hint: " + e.getMessage(), e);
            }
        }
        if (this.loginHint != null) {
            params.put("login_hint", this.loginHint);
        }
        if (this.acrValues != null) {
            sb = new StringBuilder();
            for (ACR acr : this.acrValues) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(acr.toString());
            }
            params.put("acr_values", sb.toString());
        }
        if (this.claims != null) {
            params.put("claims", this.claims.toJSONObject().toString());
        }
        if (this.requestObject != null) {
            try {
                params.put("request", this.requestObject.serialize());
            }
            catch (IllegalStateException e) {
                throw new SerializeException("Couldn't serialize request object to JWT: " + e.getMessage(), e);
            }
        }
        if (this.requestURI != null) {
            params.put("request_uri", this.requestURI.toString());
        }
        return params;
    }

    public static OIDCAuthorizationRequest parse(URL uri, Map<String, String> params) throws ParseException {
        Prompt prompt;
        Display display;
        AuthorizationRequest ar = AuthorizationRequest.parse(uri, params);
        ClientID clientID = ar.getClientID();
        State state = ar.getState();
        URL redirectURI = ar.getRedirectionURI();
        if (redirectURI == null) {
            throw new ParseException("Missing \"redirect_uri\" parameter", OAuth2Error.INVALID_REQUEST, clientID, null, state);
        }
        ResponseType rt = ar.getResponseType();
        try {
            OIDCResponseTypeValidator.validate(rt);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Unsupported \"response_type\" parameter: " + e.getMessage(), OAuth2Error.UNSUPPORTED_RESPONSE_TYPE, clientID, redirectURI, state);
        }
        Scope scope = ar.getScope();
        if (scope == null) {
            throw new ParseException("Missing \"scope\" parameter", OAuth2Error.INVALID_REQUEST, clientID, redirectURI, state);
        }
        if (!scope.contains(OIDCScopeValue.OPENID)) {
            throw new ParseException("The scope must include an \"openid\" token", OAuth2Error.INVALID_REQUEST, clientID, redirectURI, state);
        }
        Nonce nonce = Nonce.parse(params.get("nonce"));
        if (rt.impliesImplicitFlow() && nonce == null) {
            throw new ParseException("Missing \"nonce\" parameter: Required in implicit flow", OAuth2Error.INVALID_REQUEST, clientID, redirectURI, state);
        }
        try {
            display = Display.parse(params.get("display"));
        }
        catch (ParseException e) {
            throw new ParseException("Invalid \"display\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, clientID, redirectURI, state, e);
        }
        try {
            prompt = Prompt.parse(params.get("prompt"));
        }
        catch (ParseException e) {
            throw new ParseException("Invalid \"prompt\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, clientID, redirectURI, state, e);
        }
        String v = params.get("max_age");
        int maxAge = 0;
        if (StringUtils.isNotBlank((CharSequence)v)) {
            try {
                maxAge = Integer.parseInt(v);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid \"max_age\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, clientID, redirectURI, state, e);
            }
        }
        v = params.get("ui_locales");
        LinkedList<LangTag> uiLocales = null;
        if (StringUtils.isNotBlank((CharSequence)v)) {
            uiLocales = new LinkedList<LangTag>();
            StringTokenizer st = new StringTokenizer(v, " ");
            while (st.hasMoreTokens()) {
                try {
                    uiLocales.add(LangTag.parse((String)st.nextToken()));
                }
                catch (LangTagException e) {
                    throw new ParseException("Invalid \"ui_locales\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, clientID, redirectURI, state, e);
                }
            }
        }
        v = params.get("claims_locales");
        LinkedList<LangTag> claimsLocales = null;
        if (StringUtils.isNotBlank((CharSequence)v)) {
            claimsLocales = new LinkedList<LangTag>();
            StringTokenizer st = new StringTokenizer(v, " ");
            while (st.hasMoreTokens()) {
                try {
                    claimsLocales.add(LangTag.parse((String)st.nextToken()));
                }
                catch (LangTagException e) {
                    throw new ParseException("Invalid \"claims_locales\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, clientID, redirectURI, state, e);
                }
            }
        }
        v = params.get("id_token_hint");
        JWT idTokenHint = null;
        if (StringUtils.isNotBlank((CharSequence)v)) {
            try {
                idTokenHint = JWTParser.parse((String)v);
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Invalid \"id_token_hint\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, clientID, redirectURI, state, e);
            }
        }
        String loginHint = params.get("login_hint");
        v = params.get("acr_values");
        LinkedList<ACR> acrValues = null;
        if (StringUtils.isNotBlank((CharSequence)v)) {
            acrValues = new LinkedList<ACR>();
            StringTokenizer st = new StringTokenizer(v, " ");
            while (st.hasMoreTokens()) {
                acrValues.add(new ACR(st.nextToken()));
            }
        }
        v = params.get("claims");
        ClaimsRequest claims = null;
        if (StringUtils.isNotBlank((CharSequence)v)) {
            JSONObject jsonObject;
            try {
                jsonObject = JSONObjectUtils.parseJSONObject(v);
            }
            catch (ParseException e) {
                throw new ParseException("Invalid \"claims\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, clientID, redirectURI, state, e);
            }
            claims = ClaimsRequest.parse(jsonObject);
        }
        v = params.get("request_uri");
        URL requestURI = null;
        if (StringUtils.isNotBlank((CharSequence)v)) {
            try {
                requestURI = new URL(v);
            }
            catch (MalformedURLException e) {
                throw new ParseException("Invalid \"redirect_uri\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, clientID, redirectURI, state, e);
            }
        }
        v = params.get("request");
        JWT requestObject = null;
        if (StringUtils.isNotBlank((CharSequence)v)) {
            if (requestURI != null) {
                throw new ParseException("Invalid request: Found mutually exclusive \"request\" and \"request_uri\" parameters", OAuth2Error.INVALID_REQUEST, clientID, redirectURI, state, null);
            }
            try {
                requestObject = JWTParser.parse((String)v);
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Invalid \"request_object\" parameter: " + e.getMessage(), OAuth2Error.INVALID_REQUEST, clientID, redirectURI, state, e);
            }
        }
        if (requestObject != null) {
            return new OIDCAuthorizationRequest(uri, rt, scope, clientID, redirectURI, state, nonce, display, prompt, maxAge, uiLocales, claimsLocales, idTokenHint, loginHint, acrValues, claims, requestObject);
        }
        if (requestURI != null) {
            return new OIDCAuthorizationRequest(uri, rt, scope, clientID, redirectURI, state, nonce, display, prompt, maxAge, uiLocales, claimsLocales, idTokenHint, loginHint, acrValues, claims, requestURI);
        }
        return new OIDCAuthorizationRequest(uri, rt, scope, clientID, redirectURI, state, nonce, display, prompt, maxAge, uiLocales, claimsLocales, idTokenHint, loginHint, acrValues, claims);
    }

    public static OIDCAuthorizationRequest parse(URL uri, String query) throws ParseException {
        return OIDCAuthorizationRequest.parse(uri, URLUtils.parseParameters(query));
    }

    public static AuthorizationRequest parse(HTTPRequest httpRequest) throws ParseException {
        String query = httpRequest.getQuery();
        if (query == null) {
            throw new ParseException("Missing URL query string");
        }
        return OIDCAuthorizationRequest.parse(httpRequest.getURL(), query);
    }
}

