/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.oauth2.sdk;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Identifier;
import java.util.HashSet;
import java.util.StringTokenizer;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang3.StringUtils;

@NotThreadSafe
public class ResponseType
extends HashSet<Value> {
    public static ResponseType getDefault() {
        ResponseType defaultResponseType = new ResponseType();
        defaultResponseType.add(Value.CODE);
        return defaultResponseType;
    }

    public static ResponseType parse(String s) throws ParseException {
        if (StringUtils.isBlank((CharSequence)s)) {
            throw new ParseException("Null or empty response type string");
        }
        ResponseType rt = new ResponseType();
        StringTokenizer st = new StringTokenizer(s, " ");
        while (st.hasMoreTokens()) {
            rt.add(new Value(st.nextToken()));
        }
        return rt;
    }

    public boolean impliesCodeFlow() {
        return this.contains(Value.CODE);
    }

    public boolean impliesImplicitFlow() {
        return !this.impliesCodeFlow();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Value v : this) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(v.getValue());
        }
        return sb.toString();
    }

    @Immutable
    public static final class Value
    extends Identifier {
        public static final Value CODE = new Value("code");
        public static final Value TOKEN = new Value("token");

        public Value(String value) {
            super(value);
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Value && this.toString().equals(object.toString());
        }
    }
}

