/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.zipkin.util;

import com.nike.wingtips.zipkin.util.ZipkinSpanSender;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.Codec;
import zipkin.Span;

public class ZipkinSpanSenderDefaultHttpImpl
implements ZipkinSpanSender {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int DEFAULT_SPAN_BATCH_SENDING_PERIOD_MILLIS = 1000;
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 5000;
    public static final int DEFAULT_READ_TIMEOUT_MILLIS = 10000;
    protected final URL postZipkinSpansUrl;
    protected final boolean compressZipkinSpanPayload;
    protected final int connectTimeoutMillis;
    protected final int readTimeoutMillis;
    protected final ZipkinSpanSenderJob senderJob;
    protected final BlockingQueue<Span> zipkinSpanSendingQueue = new LinkedBlockingQueue<Span>();
    protected final ScheduledExecutorService zipkinSpanSendingScheduler;

    public ZipkinSpanSenderDefaultHttpImpl(String postZipkinSpansBaseUrl, boolean compressZipkinSpanPayload, int connectTimeoutMillis, int readTimeoutMillis, int batchSendingPeriodMillis) {
        try {
            String urlString = postZipkinSpansBaseUrl + (postZipkinSpansBaseUrl.endsWith("/") ? "" : "/") + "api/v1/spans";
            this.postZipkinSpansUrl = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.compressZipkinSpanPayload = compressZipkinSpanPayload;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.readTimeoutMillis = readTimeoutMillis;
        this.senderJob = new ZipkinSpanSenderJob(this, this.zipkinSpanSendingQueue);
        this.zipkinSpanSendingScheduler = this.configureScheduledExecutorServiceForBatching();
        if (batchSendingPeriodMillis > 0) {
            this.zipkinSpanSendingScheduler.scheduleAtFixedRate(this.senderJob, batchSendingPeriodMillis, batchSendingPeriodMillis, TimeUnit.MILLISECONDS);
        }
    }

    public ZipkinSpanSenderDefaultHttpImpl(String postZipkinSpansBaseUrl, boolean compressZipkinSpanPayload) {
        this(postZipkinSpansBaseUrl, compressZipkinSpanPayload, 5000, 10000, 1000);
    }

    @Override
    public void handleSpan(Span span) {
        this.zipkinSpanSendingQueue.offer(span);
    }

    @Override
    public void flush() {
        this.zipkinSpanSendingScheduler.execute(this.senderJob);
    }

    protected ScheduledExecutorService configureScheduledExecutorServiceForBatching() {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "zipkin-span-sender");
            }
        });
    }

    protected void sendSpans(List<Span> spanList) {
        try {
            this.sendSpans(Codec.JSON.writeSpans(spanList));
        }
        catch (IOException e) {
            HashSet<String> affectedTraceIds = new HashSet<String>(spanList.size());
            for (Span span : spanList) {
                affectedTraceIds.add(String.valueOf(span.traceId));
            }
            this.logger.error("An error occurred attempting to post Zipkin spans to the Zipkin server. affected_trace_ids={}, exception_cause=\"{}\"", (Object)((Object)affectedTraceIds).toString(), (Object)e.toString());
        }
    }

    protected void sendSpans(byte[] spanListJsonPayloadBytes) throws IOException {
        Throwable throwable;
        Object compressor;
        this.logger.trace("Sending spans to zipkin");
        HttpURLConnection connection = (HttpURLConnection)this.postZipkinSpansUrl.openConnection();
        connection.setConnectTimeout(this.connectTimeoutMillis);
        connection.setReadTimeout(this.readTimeoutMillis);
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Content-Type", "application/json");
        if (this.compressZipkinSpanPayload) {
            connection.addRequestProperty("Content-Encoding", "gzip");
            ByteArrayOutputStream gzipped = new ByteArrayOutputStream();
            compressor = new GZIPOutputStream(gzipped);
            throwable = null;
            try {
                ((FilterOutputStream)compressor).write(spanListJsonPayloadBytes);
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
            finally {
                if (compressor != null) {
                    if (throwable != null) {
                        try {
                            ((DeflaterOutputStream)compressor).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        ((DeflaterOutputStream)compressor).close();
                    }
                }
            }
            spanListJsonPayloadBytes = gzipped.toByteArray();
        }
        connection.setDoOutput(true);
        connection.setFixedLengthStreamingMode(spanListJsonPayloadBytes.length);
        connection.getOutputStream().write(spanListJsonPayloadBytes);
        try {
            InputStream in = connection.getInputStream();
            compressor = null;
            try {
                while (in.read() != -1) {
                }
            }
            catch (Throwable throwable2) {
                compressor = throwable2;
                throw throwable2;
            }
            finally {
                if (in != null) {
                    if (compressor != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)compressor).addSuppressed(x2);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throwable = null;
            try (InputStream err = connection.getErrorStream();){
                if (err != null) {
                    while (err.read() != -1) {
                    }
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            throw e;
        }
    }

    protected static class ZipkinSpanSenderJob
    implements Runnable {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        protected final ZipkinSpanSenderDefaultHttpImpl zipkinSpanSender;
        protected final BlockingQueue<Span> zipkinSpanSendingQueue;

        public ZipkinSpanSenderJob(ZipkinSpanSenderDefaultHttpImpl zipkinSpanSender, BlockingQueue<Span> zipkinSpanSendingQueue) {
            this.zipkinSpanSender = zipkinSpanSender;
            this.zipkinSpanSendingQueue = zipkinSpanSendingQueue;
        }

        @Override
        public void run() {
            try {
                if (this.zipkinSpanSendingQueue.isEmpty()) {
                    return;
                }
                ArrayList<Span> drainedSpans = new ArrayList<Span>(this.zipkinSpanSendingQueue.size());
                this.zipkinSpanSendingQueue.drainTo(drainedSpans);
                if (!drainedSpans.isEmpty()) {
                    this.zipkinSpanSender.sendSpans(drainedSpans);
                }
            }
            catch (Throwable ex) {
                this.logger.error("An unexpected error occurred attempting to post Zipkin spans to the Zipkin server.", ex);
            }
        }
    }
}

