/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.zipkin.util;

import com.nike.wingtips.Span;
import com.nike.wingtips.TraceAndSpanIdGenerator;
import com.nike.wingtips.zipkin.util.WingtipsToZipkinSpanConverter;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Endpoint;
import zipkin.Span;

public class WingtipsToZipkinSpanConverterDefaultImpl
implements WingtipsToZipkinSpanConverter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public zipkin.Span convertWingtipsSpanToZipkinSpan(Span wingtipsSpan, Endpoint zipkinEndpoint, String localComponentNamespace) {
        long startEpochMicros = wingtipsSpan.getSpanStartTimeEpochMicros();
        long durationMicros = TimeUnit.NANOSECONDS.toMicros(wingtipsSpan.getDurationNanos());
        return this.createNewZipkinSpanBuilderWithSpanPurposeAnnotations(wingtipsSpan, startEpochMicros, durationMicros, zipkinEndpoint, localComponentNamespace).id(this.nullSafeLong(wingtipsSpan.getSpanId()).longValue()).name(wingtipsSpan.getSpanName()).parentId(this.nullSafeLong(wingtipsSpan.getParentSpanId())).timestamp(Long.valueOf(startEpochMicros)).traceId(this.nullSafeLong(wingtipsSpan.getTraceId()).longValue()).duration(Long.valueOf(durationMicros)).build();
    }

    protected Span.Builder createNewZipkinSpanBuilderWithSpanPurposeAnnotations(Span wingtipsSpan, long startEpochMicros, long durationMicros, Endpoint zipkinEndpoint, String localComponentNamespace) {
        Span.Builder zsb = zipkin.Span.builder();
        switch (wingtipsSpan.getSpanPurpose()) {
            case SERVER: {
                zsb.addAnnotation(Annotation.create((long)startEpochMicros, (String)"sr", (Endpoint)zipkinEndpoint)).addAnnotation(Annotation.create((long)(startEpochMicros + durationMicros), (String)"ss", (Endpoint)zipkinEndpoint));
                break;
            }
            case CLIENT: {
                zsb.addAnnotation(Annotation.create((long)startEpochMicros, (String)"cs", (Endpoint)zipkinEndpoint)).addAnnotation(Annotation.create((long)(startEpochMicros + durationMicros), (String)"cr", (Endpoint)zipkinEndpoint));
                break;
            }
            case LOCAL_ONLY: 
            case UNKNOWN: {
                zsb.addBinaryAnnotation(BinaryAnnotation.create((String)"lc", (String)localComponentNamespace, (Endpoint)zipkinEndpoint));
                break;
            }
            default: {
                this.logger.warn("Unhandled SpanPurpose type: " + wingtipsSpan.getSpanPurpose().name());
            }
        }
        return zsb;
    }

    protected Long nullSafeLong(String lowerHexStr) {
        if (lowerHexStr == null) {
            return null;
        }
        return TraceAndSpanIdGenerator.unsignedLowerHexStringToLong((String)lowerHexStr);
    }
}

