/*
 * Decompiled with CFR 0.152.
 */
package com.nike.wingtips.zipkin;

import com.nike.wingtips.Span;
import com.nike.wingtips.lifecyclelistener.SpanLifecycleListener;
import com.nike.wingtips.zipkin.util.WingtipsToZipkinSpanConverter;
import com.nike.wingtips.zipkin.util.WingtipsToZipkinSpanConverterDefaultImpl;
import com.nike.wingtips.zipkin.util.ZipkinSpanSender;
import com.nike.wingtips.zipkin.util.ZipkinSpanSenderDefaultHttpImpl;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin.Endpoint;

public class WingtipsToZipkinLifecycleListener
implements SpanLifecycleListener {
    private final Logger zipkinConversionOrReportingErrorLogger = LoggerFactory.getLogger((String)"ZIPKIN_SPAN_CONVERSION_OR_HANDLING_ERROR");
    protected final String serviceName;
    protected final String localComponentNamespace;
    protected final Endpoint zipkinEndpoint;
    protected final WingtipsToZipkinSpanConverter zipkinSpanConverter;
    protected final ZipkinSpanSender zipkinSpanSender;
    protected final AtomicLong spanHandlingErrorCounter = new AtomicLong(0L);
    protected long lastSpanHandlingErrorLogTimeEpochMillis = 0L;
    protected static final long MIN_SPAN_HANDLING_ERROR_LOG_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(60L);

    public WingtipsToZipkinLifecycleListener(String serviceName, String localComponentNamespace, WingtipsToZipkinSpanConverter zipkinSpanConverter, ZipkinSpanSender zipkinSpanSender) {
        this.serviceName = serviceName;
        this.localComponentNamespace = localComponentNamespace;
        this.zipkinEndpoint = Endpoint.builder().serviceName(serviceName).build();
        this.zipkinSpanConverter = zipkinSpanConverter;
        this.zipkinSpanSender = zipkinSpanSender;
    }

    public WingtipsToZipkinLifecycleListener(String serviceName, String localComponentNamespace, String postZipkinSpansBaseUrl) {
        this(serviceName, localComponentNamespace, new WingtipsToZipkinSpanConverterDefaultImpl(), new ZipkinSpanSenderDefaultHttpImpl(postZipkinSpansBaseUrl, true));
    }

    public void spanStarted(Span span) {
    }

    public void spanSampled(Span span) {
    }

    public void spanCompleted(Span span) {
        block2: {
            try {
                zipkin.Span zipkinSpan = this.zipkinSpanConverter.convertWingtipsSpanToZipkinSpan(span, this.zipkinEndpoint, this.localComponentNamespace);
                this.zipkinSpanSender.handleSpan(zipkinSpan);
            }
            catch (Throwable ex) {
                long currentBadSpanCount = this.spanHandlingErrorCounter.incrementAndGet();
                long currentTimeMillis = System.currentTimeMillis();
                long timeSinceLastLogMsgMillis = currentTimeMillis - this.lastSpanHandlingErrorLogTimeEpochMillis;
                if (timeSinceLastLogMsgMillis < MIN_SPAN_HANDLING_ERROR_LOG_INTERVAL_MILLIS) break block2;
                this.lastSpanHandlingErrorLogTimeEpochMillis = currentTimeMillis;
                this.zipkinConversionOrReportingErrorLogger.warn("There have been {} spans that were not zipkin compatible, or that experienced an error during span handling. Latest example: wingtips_span_with_error=\"{}\", conversion_or_handling_error=\"{}\"", new Object[]{currentBadSpanCount, span.toKeyValueString(), ex.toString()});
            }
        }
    }
}

