/*
 * Decompiled with CFR 0.152.
 */
package com.websocket.client.util;

import com.websocket.client.QSocket;
import com.websocket.client.QSocketOptions;
import com.websocket.client.channel.impl.ChannelImpl;
import com.websocket.client.channel.impl.ChannelManager;
import com.websocket.client.connection.impl.InternalConnection;
import com.websocket.client.connection.websocket.WebSocketClientWrapper;
import com.websocket.client.connection.websocket.WebSocketConnection;
import com.websocket.client.connection.websocket.WebSocketListener;
import com.websocket.client.util.ConnectivityChangeReceiver;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLException;
import org.java_websocket.client.WebSocketClient;

public class Factory {
    private InternalConnection connection;
    private ChannelManager channelManager;
    private ExecutorService eventQueue;
    private ScheduledExecutorService timers;
    private ConnectivityChangeReceiver connectivityChangeReceiver;
    private static final Object eventLock = new Object();

    public synchronized InternalConnection getConnection(QSocketOptions options) {
        if (this.connection == null) {
            try {
                this.connection = new WebSocketConnection(options.buildUrl(), options.getActivityTimeout(), options.getPongTimeout(), options.getProxy(), this, options.getUrlHeader());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Failed to initialise com.websocket.client.connection", e);
            }
        }
        return this.connection;
    }

    public WebSocketClient newWebSocketClientWrapper(URI uri, Proxy proxy, WebSocketListener webSocketListener, HashMap<String, String> header) throws SSLException {
        return new WebSocketClientWrapper(uri, proxy, webSocketListener, header);
    }

    public synchronized ScheduledExecutorService getTimers() {
        if (this.timers == null) {
            this.timers = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory("timers"));
        }
        return this.timers;
    }

    public ChannelImpl newPublicChannel(String channelName) {
        return new ChannelImpl(channelName, this);
    }

    public synchronized ChannelManager getChannelManager() {
        if (this.channelManager == null) {
            this.channelManager = new ChannelManager(this);
        }
        return this.channelManager;
    }

    public synchronized ConnectivityChangeReceiver getConnectivityChangeReceiver(QSocket qSocket) {
        if (this.connectivityChangeReceiver == null) {
            this.connectivityChangeReceiver = new ConnectivityChangeReceiver(qSocket);
        }
        return this.connectivityChangeReceiver;
    }

    public synchronized void queueOnEventThread(final Runnable r) {
        if (this.eventQueue == null) {
            this.eventQueue = Executors.newSingleThreadExecutor(new DaemonThreadFactory("eventQueue"));
        }
        this.eventQueue.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = eventLock;
                synchronized (object) {
                    r.run();
                }
            }
        });
    }

    public synchronized void shutdownThreads() {
        if (this.eventQueue != null) {
            this.eventQueue.shutdown();
            this.eventQueue = null;
        }
        if (this.timers != null) {
            this.timers.shutdown();
            this.timers = null;
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final String name;

        public DaemonThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName("qsocket-java-client " + this.name);
            return t;
        }
    }
}

