/*
 * Decompiled with CFR 0.152.
 */
package com.websocket.client.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class ConnectivityChangeReceiver
extends BroadcastReceiver {
    private ConnectivityChangeListener connectivityChangeListener;

    public ConnectivityChangeReceiver() {
    }

    public ConnectivityChangeReceiver(ConnectivityChangeListener listener) {
        this.connectivityChangeListener = listener;
    }

    public void onReceive(Context context, Intent intent) {
        if (this.isOnline(context) && this.connectivityChangeListener != null) {
            this.connectivityChangeListener.onNetworkAvailable();
        }
    }

    private boolean isOnline(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        return netInfo != null && netInfo.isConnected();
    }

    public static interface ConnectivityChangeListener {
        public void onNetworkAvailable();
    }
}

