/*
 * Decompiled with CFR 0.152.
 */
package com.websocket.client.connection.websocket;

import com.websocket.client.connection.websocket.WebSocketListener;
import java.io.IOException;
import java.net.Proxy;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_17;
import org.java_websocket.handshake.ServerHandshake;

public class WebSocketClientWrapper
extends WebSocketClient {
    private static final String WSS_SCHEME = "wss";
    private final WebSocketListener webSocketListener;

    public WebSocketClientWrapper(URI uri, Proxy proxy, WebSocketListener webSocketListener, HashMap<String, String> header) throws SSLException {
        super(uri, (Draft)new Draft_17(), header, 0);
        if (uri.getScheme().equals(WSS_SCHEME)) {
            try {
                SSLContext sslContext = null;
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, null, null);
                SSLSocketFactory factory = sslContext.getSocketFactory();
                this.setSocket(factory.createSocket());
            }
            catch (IOException e) {
                throw new SSLException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SSLException(e);
            }
            catch (KeyManagementException e) {
                throw new SSLException(e);
            }
        }
        this.webSocketListener = webSocketListener;
        this.setProxy(proxy);
    }

    public void onOpen(ServerHandshake handshakedata) {
        this.webSocketListener.onOpen(handshakedata);
    }

    public void onMessage(String message) {
        this.webSocketListener.onMessage(message);
    }

    public void onClose(int code, String reason, boolean remote) {
        this.webSocketListener.onClose(code, reason, remote);
    }

    public void onError(Exception ex) {
        this.webSocketListener.onError(ex);
    }
}

