/*
 * Decompiled with CFR 0.152.
 */
package com.websocket.client.channel.impl;

import android.util.Log;
import com.google.gson.Gson;
import com.websocket.client.channel.Channel;
import com.websocket.client.channel.ChannelEventListener;
import com.websocket.client.channel.ChannelState;
import com.websocket.client.channel.ChannelUnsubscriptionEventListener;
import com.websocket.client.channel.impl.InternalChannel;
import com.websocket.client.connection.ConnectionEventListener;
import com.websocket.client.connection.ConnectionState;
import com.websocket.client.connection.ConnectionStateChange;
import com.websocket.client.connection.impl.InternalConnection;
import com.websocket.client.util.Factory;
import java.util.HashMap;
import java.util.Map;

public class ChannelManager
implements ConnectionEventListener {
    private static final Gson GSON = new Gson();
    private final Map<String, InternalChannel> channelNameToChannelMap = new HashMap<String, InternalChannel>();
    private final Factory factory;
    private InternalConnection connection;

    public ChannelManager(Factory factory) {
        this.factory = factory;
    }

    public Channel getChannel(String channelName) {
        return this.findChannelInChannelMap(channelName);
    }

    private InternalChannel findChannelInChannelMap(String channelName) {
        return this.channelNameToChannelMap.get(channelName);
    }

    public void setConnection(InternalConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Cannot construct ChannelManager with a null com.websocket.client.connection");
        }
        if (this.connection != null) {
            this.connection.unbind(ConnectionState.CONNECTED, this);
        }
        this.connection = connection;
        connection.bind(ConnectionState.CONNECTED, this);
    }

    public void subscribeTo(InternalChannel channel, ChannelEventListener listener, String ... eventNames) {
        try {
            this.validateArgumentsAndBindEvents(channel, listener, eventNames);
            this.channelNameToChannelMap.put(channel.getName(), channel);
            this.sendOrQueueSubscribeMessage(channel);
        }
        catch (IllegalArgumentException e) {
            Log.v((String)"message", (String)e.getMessage());
        }
    }

    public void unsubscribeFrom(String channelName, ChannelUnsubscriptionEventListener channelUnsubscriptionEventListeneristener) {
        if (channelName == null) {
            throw new IllegalArgumentException("Cannot unsubscribe from null com.websocket.client.channel");
        }
        InternalChannel channel = this.channelNameToChannelMap.remove(channelName);
        if (channel == null) {
            return;
        }
        channel.setUnsubscribeEventListener(channelUnsubscriptionEventListeneristener);
        if (this.connection.getState() == ConnectionState.CONNECTED) {
            this.sendUnsubscribeMessage(channel);
        }
    }

    public void onMessage(String event, String wholeMessage) {
        String channelName;
        InternalChannel channel;
        Map json = (Map)GSON.fromJson(wholeMessage, Map.class);
        Object channelNameObject = json.get("channel");
        if (channelNameObject != null && (channel = this.channelNameToChannelMap.get(channelName = (String)channelNameObject)) != null) {
            channel.onMessage(event, wholeMessage);
        }
    }

    @Override
    public void onConnectionStateChange(ConnectionStateChange change) {
        if (change.getCurrentState() == ConnectionState.CONNECTED) {
            for (InternalChannel channel : this.channelNameToChannelMap.values()) {
                this.sendOrQueueSubscribeMessage(channel);
            }
        }
    }

    @Override
    public void onError(String message, String code, Exception e) {
    }

    private void sendOrQueueSubscribeMessage(final InternalChannel channel) {
        this.factory.queueOnEventThread(new Runnable(){

            @Override
            public void run() {
                if (ChannelManager.this.connection.getState() == ConnectionState.CONNECTED) {
                    String message = channel.toSubscribeMessage();
                    ChannelManager.this.connection.sendMessage(message);
                    channel.updateState(ChannelState.SUBSCRIBE_SENT);
                }
            }
        });
    }

    private void sendUnsubscribeMessage(final InternalChannel channel) {
        this.factory.queueOnEventThread(new Runnable(){

            @Override
            public void run() {
                ChannelManager.this.connection.sendMessage(channel.toUnsubscribeMessage());
                channel.updateState(ChannelState.UNSUBSCRIBED);
            }
        });
    }

    private void clearDownSubscription(InternalChannel channel, Exception e) {
        this.channelNameToChannelMap.remove(channel.getName());
        channel.updateState(ChannelState.FAILED);
    }

    private void validateArgumentsAndBindEvents(InternalChannel channel, ChannelEventListener listener, String ... eventNames) {
        if (channel == null) {
            throw new IllegalArgumentException("Cannot subscribe to a null com.websocket.client.channel");
        }
        if (this.channelNameToChannelMap.containsKey(channel.getName())) {
            throw new IllegalArgumentException("Already subscribed to a com.websocket.client.channel with name " + channel.getName());
        }
        for (String eventName : eventNames) {
            channel.bind(eventName, listener);
        }
        channel.setEventListener(listener);
    }
}

