/*
 * Decompiled with CFR 0.152.
 */
package com.websocket.client.channel.impl;

import com.google.gson.Gson;
import com.websocket.client.channel.ChannelEventListener;
import com.websocket.client.channel.ChannelState;
import com.websocket.client.channel.ChannelUnsubscriptionEventListener;
import com.websocket.client.channel.SubscriptionEventListener;
import com.websocket.client.channel.impl.InternalChannel;
import com.websocket.client.util.Factory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ChannelImpl
implements InternalChannel {
    private static final Gson GSON = new Gson();
    private static final String SUBSCRIPTION_SUCCESS_EVENT = "103";
    private static final String UNSUBSCRIPTION_SUCCESS_EVENT = "104";
    private static final String INTERNAL_EVENT_PREFIX = "qsocket_internal:";
    protected final String name;
    private final Map<String, Set<SubscriptionEventListener>> eventNameToListenerMap = new HashMap<String, Set<SubscriptionEventListener>>();
    protected volatile ChannelState state = ChannelState.INITIAL;
    private ChannelEventListener eventListener;
    private ChannelUnsubscriptionEventListener channelUnsubscriptionEventListener;
    private final Factory factory;
    private final Object lock = new Object();

    public ChannelImpl(String channelName, Factory factory) {
        if (channelName == null) {
            throw new IllegalArgumentException("Cannot subscribe to a channel with a null name");
        }
        this.name = channelName;
        this.factory = factory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String eventName, SubscriptionEventListener listener) {
        this.validateArguments(eventName, listener);
        Object object = this.lock;
        synchronized (object) {
            Set<SubscriptionEventListener> listeners = this.eventNameToListenerMap.get(eventName);
            if (listeners == null) {
                listeners = new HashSet<SubscriptionEventListener>();
                this.eventNameToListenerMap.put(eventName, listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(String eventName, SubscriptionEventListener listener) {
        this.validateArguments(eventName, listener);
        Object object = this.lock;
        synchronized (object) {
            Set<SubscriptionEventListener> listeners = this.eventNameToListenerMap.get(eventName);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.eventNameToListenerMap.remove(eventName);
                }
            }
        }
    }

    @Override
    public boolean isSubscribed() {
        return this.state == ChannelState.SUBSCRIBED;
    }

    @Override
    public void onMessage(final String event, String message) {
        if (event.equals(SUBSCRIPTION_SUCCESS_EVENT)) {
            this.updateState(ChannelState.SUBSCRIBED);
        } else if (event.equals(UNSUBSCRIPTION_SUCCESS_EVENT)) {
            this.updateState(ChannelState.UNSUBSCRIBED);
        } else {
            final String data = this.extractDataFrom(message);
            this.factory.queueOnEventThread(new Runnable(){

                @Override
                public void run() {
                    ChannelImpl.this.eventListener.onEvent(ChannelImpl.this.name, event, data);
                }
            });
        }
    }

    @Override
    public String toSubscribeMessage() {
        LinkedHashMap<String, String> jsonObject = new LinkedHashMap<String, String>();
        jsonObject.put("command", "subscribe");
        jsonObject.put("channel", this.name);
        return GSON.toJson(jsonObject);
    }

    @Override
    public String toUnsubscribeMessage() {
        LinkedHashMap<String, String> jsonObject = new LinkedHashMap<String, String>();
        jsonObject.put("command", "unsubscribe");
        jsonObject.put("channel", this.name);
        return GSON.toJson(jsonObject);
    }

    @Override
    public void updateState(ChannelState state) {
        this.state = state;
        if (state == ChannelState.SUBSCRIBED && this.eventListener != null) {
            this.factory.queueOnEventThread(new Runnable(){

                @Override
                public void run() {
                    ChannelImpl.this.eventListener.onSubscriptionSucceeded(ChannelImpl.this.getName());
                }
            });
        } else if (state == ChannelState.UNSUBSCRIBED && this.channelUnsubscriptionEventListener != null) {
            this.factory.queueOnEventThread(new Runnable(){

                @Override
                public void run() {
                    ChannelImpl.this.channelUnsubscriptionEventListener.onUnsubscribed(ChannelImpl.this.getName());
                }
            });
        }
    }

    @Override
    public void setEventListener(ChannelEventListener listener) {
        this.eventListener = listener;
    }

    @Override
    public void setUnsubscribeEventListener(ChannelUnsubscriptionEventListener listener) {
        this.channelUnsubscriptionEventListener = listener;
    }

    @Override
    public ChannelEventListener getEventListener() {
        return this.eventListener;
    }

    @Override
    public int compareTo(InternalChannel other) {
        return this.getName().compareTo(other.getName());
    }

    public String toString() {
        return String.format("[Public Channel: name=%s]", this.name);
    }

    private String extractDataFrom(String message) {
        return message;
    }

    private void validateArguments(String eventName, SubscriptionEventListener listener) {
        if (eventName == null) {
            throw new IllegalArgumentException("Cannot bind or unbind to channel " + this.name + " with a null event name");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Cannot bind or unbind to channel " + this.name + " with a null listener");
        }
        if (eventName.startsWith(INTERNAL_EVENT_PREFIX)) {
            throw new IllegalArgumentException("Cannot bind or unbind channel " + this.name + " with an internal event name such as " + eventName);
        }
        if (this.state == ChannelState.UNSUBSCRIBED) {
            throw new IllegalStateException("Cannot bind or unbind to events on a channel that has been unsubscribed. Call Pusher.subscribe() to resubscribe to this channel");
        }
    }
}

