/*
 * Decompiled with CFR 0.152.
 */
package com.websocket.client;

import java.net.Proxy;
import java.util.HashMap;

public class QSocketOptions {
    private static final String URI_SUFFIX = "uri_suffix";
    private static final String WS_SCHEME = "ws";
    private static final String WSS_SCHEME = "wss";
    private static final int WS_PORT = 4444;
    private static final int WSS_PORT = 4444;
    private static final String QSOCKET_DOMAIN = "qsocket.com";
    private static final long DEFAULT_ACTIVITY_TIMEOUT = 120000L;
    private static final long DEFAULT_PONG_TIMEOUT = 30000L;
    private static final String AUTHORIZATION = "Authorization";
    private String host = "10.3.1.181";
    private int wsPort = 4444;
    private int wssPort = 4444;
    private boolean encrypted = false;
    private long activityTimeout = 120000L;
    private long pongTimeout = 30000L;
    private Proxy proxy = Proxy.NO_PROXY;
    private String authorizationToken = "1234567890";

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public QSocketOptions setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
        return this;
    }

    public QSocketOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public QSocketOptions setWsPort(int wsPort) {
        this.wsPort = wsPort;
        return this;
    }

    public QSocketOptions setWssPort(int wssPort) {
        this.wssPort = wssPort;
        return this;
    }

    public QSocketOptions setCluster(String cluster) {
        this.host = "ws-" + cluster + "." + QSOCKET_DOMAIN;
        this.wsPort = 4444;
        this.wssPort = 4444;
        return this;
    }

    public QSocketOptions setActivityTimeout(long activityTimeout) {
        if (activityTimeout < 1000L) {
            throw new IllegalArgumentException("Activity timeout must be at least 1,000ms (and is recommended to be much higher)");
        }
        this.activityTimeout = activityTimeout;
        return this;
    }

    public long getActivityTimeout() {
        return this.activityTimeout;
    }

    public QSocketOptions setPongTimeout(long pongTimeout) {
        if (pongTimeout < 1000L) {
            throw new IllegalArgumentException("Pong timeout must be at least 1,000ms (and is recommended to be much higher)");
        }
        this.pongTimeout = pongTimeout;
        return this;
    }

    public long getPongTimeout() {
        return this.pongTimeout;
    }

    public String buildUrl() {
        return String.format("%s://%s:%s", this.encrypted ? WSS_SCHEME : WS_SCHEME, this.host, this.encrypted ? this.wssPort : this.wsPort);
    }

    public QSocketOptions setProxy(Proxy proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("proxy must not be null (instead use Proxy.NO_PROXY)");
        }
        this.proxy = proxy;
        return this;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public QSocketOptions setAuthorizationToken(String authorizationToken) {
        if (authorizationToken == null) {
            throw new IllegalArgumentException("authorizationToken must not be null");
        }
        this.authorizationToken = authorizationToken;
        return this;
    }

    public HashMap<String, String> getUrlHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put(AUTHORIZATION, this.authorizationToken);
        return header;
    }
}

