/*
 * Decompiled with CFR 0.152.
 */
package com.websocket.client;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import com.websocket.client.Client;
import com.websocket.client.QSocketOptions;
import com.websocket.client.channel.Channel;
import com.websocket.client.channel.ChannelEventListener;
import com.websocket.client.channel.ChannelUnsubscriptionEventListener;
import com.websocket.client.channel.impl.ChannelImpl;
import com.websocket.client.channel.impl.ChannelManager;
import com.websocket.client.connection.Connection;
import com.websocket.client.connection.ConnectionEventListener;
import com.websocket.client.connection.ConnectionState;
import com.websocket.client.connection.impl.InternalConnection;
import com.websocket.client.util.ConnectivityChangeReceiver;
import com.websocket.client.util.Factory;

public class QSocket
implements Client,
ConnectivityChangeReceiver.ConnectivityChangeListener {
    private final QSocketOptions QSocketOptions;
    private final InternalConnection connection;
    private final ChannelManager channelManager;
    private final Factory factory;
    private Context context;

    public QSocket(Context context) {
        this(new QSocketOptions(), context);
    }

    public QSocket(QSocketOptions QSocketOptions2, Context context) {
        this(QSocketOptions2, new Factory(), context);
    }

    QSocket(QSocketOptions QSocketOptions2, Factory factory, Context context) {
        if (QSocketOptions2 == null) {
            throw new IllegalArgumentException("QSocketOptions cannot be null");
        }
        this.QSocketOptions = QSocketOptions2;
        this.factory = factory;
        this.connection = factory.getConnection(this.QSocketOptions);
        this.channelManager = factory.getChannelManager();
        this.channelManager.setConnection(this.connection);
        this.context = context;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void connect() {
        this.connect(null, new ConnectionState[0]);
    }

    @Override
    public void connect(ConnectionEventListener eventListener, ConnectionState ... connectionStates) {
        if (eventListener != null) {
            if (connectionStates.length == 0) {
                connectionStates = new ConnectionState[]{ConnectionState.ALL};
            }
            for (ConnectionState state : connectionStates) {
                this.connection.bind(state, eventListener);
            }
        } else if (connectionStates.length > 0) {
            throw new IllegalArgumentException("Cannot bind to connection states with a null connection event listener");
        }
        this.registerConnectivityChangeReceiver();
        this.connection.connect();
    }

    @Override
    public void disconnect() {
        if (this.connection.getState() == ConnectionState.CONNECTED) {
            this.unregisterConnectivityChangeReceiver();
            this.connection.disconnect();
        }
    }

    @Override
    public Channel subscribe(String channelName) {
        return this.subscribe(channelName, null, new String[0]);
    }

    @Override
    public Channel subscribe(String channelName, ChannelEventListener listener, String ... eventNames) {
        ChannelImpl channel = this.factory.newPublicChannel(channelName);
        this.channelManager.subscribeTo(channel, listener, eventNames);
        return channel;
    }

    @Override
    public void unsubscribe(String channelName) {
        this.channelManager.unsubscribeFrom(channelName, null);
    }

    public void unsubscribe(String channelName, ChannelUnsubscriptionEventListener channelUnsubscriptionEventListeneristener) {
        this.channelManager.unsubscribeFrom(channelName, channelUnsubscriptionEventListeneristener);
    }

    @Override
    public Channel getChannel(String channelName) {
        return this.channelManager.getChannel(channelName);
    }

    @Override
    public void onNetworkAvailable() {
        this.connect();
    }

    private void registerConnectivityChangeReceiver() {
        this.context.registerReceiver((BroadcastReceiver)this.factory.getConnectivityChangeReceiver(this), new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    private void unregisterConnectivityChangeReceiver() {
        this.context.unregisterReceiver((BroadcastReceiver)this.factory.getConnectivityChangeReceiver(this));
    }
}

