/*
 * Decompiled with CFR 0.152.
 */
package com.nichepharma.mylibrary;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.widget.ImageView;
import com.nichepharma.mylibrary.FileCache;
import com.nichepharma.mylibrary.MemoryCache;
import com.nichepharma.mylibrary.R;
import com.nichepharma.mylibrary.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ImageLoader {
    MemoryCache memoryCache = new MemoryCache();
    FileCache fileCache;
    private Map<ImageView, String> imageViews = Collections.synchronizedMap(new WeakHashMap());
    ExecutorService executorService;
    int stub_id = R.drawable.ic_launcher;

    public ImageLoader(Context context) {
        this.fileCache = new FileCache(context);
        this.executorService = Executors.newFixedThreadPool(5);
    }

    public void DisplayImage(String url, int loader, ImageView imageView) {
        this.stub_id = loader;
        this.imageViews.put(imageView, url);
        Bitmap bitmap = this.memoryCache.get(url);
        if (bitmap != null) {
            imageView.setImageBitmap(bitmap);
        } else {
            this.queuePhoto(url, imageView);
            imageView.setImageResource(loader);
        }
    }

    private void queuePhoto(String url, ImageView imageView) {
        PhotoToLoad p = new PhotoToLoad(url, imageView);
        this.executorService.submit(new PhotosLoader(p));
    }

    private Bitmap getBitmap(String url) {
        File f = this.fileCache.getFile(url);
        Bitmap b = this.decodeFile(f);
        if (b != null) {
            return b;
        }
        try {
            Bitmap bitmap = null;
            URL imageUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)imageUrl.openConnection();
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            conn.setInstanceFollowRedirects(true);
            InputStream is = conn.getInputStream();
            FileOutputStream os = new FileOutputStream(f);
            Utils.CopyStream(is, os);
            ((OutputStream)os).close();
            bitmap = this.decodeFile(f);
            return bitmap;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Bitmap decodeFile(File f) {
        try {
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)new FileInputStream(f), null, (BitmapFactory.Options)o);
            int REQUIRED_SIZE = 200;
            int width_tmp = o.outWidth;
            int height_tmp = o.outHeight;
            int scale = 1;
            while (width_tmp / 2 >= 200 && height_tmp / 2 >= 200) {
                width_tmp /= 2;
                height_tmp /= 2;
                scale *= 2;
            }
            BitmapFactory.Options o2 = new BitmapFactory.Options();
            o2.inSampleSize = scale;
            return BitmapFactory.decodeStream((InputStream)new FileInputStream(f), null, (BitmapFactory.Options)o2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    boolean imageViewReused(PhotoToLoad photoToLoad) {
        String tag = this.imageViews.get(photoToLoad.imageView);
        return tag == null || !tag.equals(photoToLoad.url);
    }

    public void clearCache() {
        this.memoryCache.clear();
        this.fileCache.clear();
    }

    class BitmapDisplayer
    implements Runnable {
        Bitmap bitmap;
        PhotoToLoad photoToLoad;

        public BitmapDisplayer(Bitmap b, PhotoToLoad p) {
            this.bitmap = b;
            this.photoToLoad = p;
        }

        @Override
        public void run() {
            if (ImageLoader.this.imageViewReused(this.photoToLoad)) {
                return;
            }
            if (this.bitmap != null) {
                this.photoToLoad.imageView.setImageBitmap(this.bitmap);
            } else {
                this.photoToLoad.imageView.setImageResource(ImageLoader.this.stub_id);
            }
        }
    }

    class PhotosLoader
    implements Runnable {
        PhotoToLoad photoToLoad;

        PhotosLoader(PhotoToLoad photoToLoad) {
            this.photoToLoad = photoToLoad;
        }

        @Override
        public void run() {
            if (ImageLoader.this.imageViewReused(this.photoToLoad)) {
                return;
            }
            Bitmap bmp = ImageLoader.this.getBitmap(this.photoToLoad.url);
            ImageLoader.this.memoryCache.put(this.photoToLoad.url, bmp);
            if (ImageLoader.this.imageViewReused(this.photoToLoad)) {
                return;
            }
            BitmapDisplayer bd = new BitmapDisplayer(bmp, this.photoToLoad);
            Activity a = (Activity)this.photoToLoad.imageView.getContext();
            a.runOnUiThread((Runnable)bd);
        }
    }

    private class PhotoToLoad {
        public String url;
        public ImageView imageView;

        public PhotoToLoad(String u, ImageView i) {
            this.url = u;
            this.imageView = i;
        }
    }
}

