/*
 * Decompiled with CFR 0.152.
 */
package com.nichepharma.myapplication;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import com.nichepharma.myapplication.R;

public class ProgressWheel
extends View {
    private int layout_height = 0;
    private int layout_width = 0;
    private int fullRadius = 0;
    private int circleRadius = 0;
    private int barLength = 0;
    private int barWidth = 0;
    private int rimWidth = 0;
    private int textSize = 0;
    private float contourSize = 0.0f;
    private int paddingTop = 5;
    private int paddingBottom = 5;
    private int paddingLeft = 5;
    private int paddingRight = 5;
    private int barColor = 0;
    private int contourColor = 0;
    private int circleColor = 0;
    private int rimColor = 0;
    private int textColor = 0;
    private Paint barPaint = new Paint();
    private Paint circlePaint = new Paint();
    private Paint rimPaint = new Paint();
    private Paint textPaint = new Paint();
    private Paint contourPaint = new Paint();
    private RectF rectBounds = new RectF();
    private RectF circleBounds = new RectF();
    private RectF circleOuterContour = new RectF();
    private RectF circleInnerContour = new RectF();
    private int spinSpeed = 2;
    private int delayMillis = 0;
    private Handler spinHandler = new Handler(){

        public void handleMessage(Message msg) {
            ProgressWheel.this.invalidate();
            if (ProgressWheel.this.isSpinning) {
                ProgressWheel.this.progress += ProgressWheel.this.spinSpeed;
                if (ProgressWheel.this.progress > 360) {
                    ProgressWheel.this.progress = 0;
                }
                ProgressWheel.this.spinHandler.sendEmptyMessageDelayed(0, (long)ProgressWheel.this.delayMillis);
            }
        }
    };
    int progress = 0;
    boolean isSpinning = false;
    private String text = "";
    private String[] splitText = new String[0];

    public ProgressWheel(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.parseAttributes(context.obtainStyledAttributes(attrs, R.styleable.ProgressWheel));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int size = 0;
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int widthWithoutPadding = width - this.getPaddingLeft() - this.getPaddingRight();
        int heigthWithoutPadding = height - this.getPaddingTop() - this.getPaddingBottom();
        size = widthWithoutPadding > heigthWithoutPadding ? heigthWithoutPadding : widthWithoutPadding;
        this.setMeasuredDimension(size + this.getPaddingLeft() + this.getPaddingRight(), size + this.getPaddingTop() + this.getPaddingBottom());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.layout_width = w;
        this.layout_height = h;
        this.setupPaints();
        this.invalidate();
    }

    private void setupPaints() {
        this.textPaint.setColor(this.textColor);
        this.textPaint.setStyle(Paint.Style.FILL);
        Typeface currentTypeFace = this.textPaint.getTypeface();
        Typeface bold = Typeface.create((Typeface)currentTypeFace, (int)1);
        this.textPaint.setTypeface(bold);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setTextSize((float)this.textSize);
    }

    private void setupBounds() {
        int minValue = Math.min(this.layout_width, this.layout_height);
        int xOffset = this.layout_width - minValue;
        int yOffset = this.layout_height - minValue;
        this.paddingTop = this.getPaddingTop() + yOffset / 2;
        this.paddingBottom = this.getPaddingBottom() + yOffset / 2;
        this.paddingLeft = this.getPaddingLeft() + xOffset / 2;
        this.paddingRight = this.getPaddingRight() + xOffset / 2;
        int width = this.getWidth();
        int height = this.getHeight();
        this.circleBounds = new RectF((float)(this.paddingLeft + this.barWidth), (float)(this.paddingTop + this.barWidth), (float)(width - this.paddingRight - this.barWidth), (float)(height - this.paddingBottom - this.barWidth));
        this.circleInnerContour = new RectF(this.circleBounds.left + (float)this.rimWidth / 2.0f + this.contourSize / 2.0f, this.circleBounds.top + (float)this.rimWidth / 2.0f + this.contourSize / 2.0f, this.circleBounds.right - (float)this.rimWidth / 2.0f - this.contourSize / 2.0f, this.circleBounds.bottom - (float)this.rimWidth / 2.0f - this.contourSize / 2.0f);
        this.circleOuterContour = new RectF(this.circleBounds.left - (float)this.rimWidth / 2.0f - this.contourSize / 2.0f, this.circleBounds.top - (float)this.rimWidth / 2.0f - this.contourSize / 2.0f, this.circleBounds.right + (float)this.rimWidth / 2.0f + this.contourSize / 2.0f, this.circleBounds.bottom + (float)this.rimWidth / 2.0f + this.contourSize / 2.0f);
        this.fullRadius = (width - this.paddingRight - this.barWidth) / 2;
        this.circleRadius = this.fullRadius - this.barWidth + 1;
    }

    private void parseAttributes(TypedArray a) {
        this.spinSpeed = (int)a.getDimension(R.styleable.ProgressWheel_spinSpeed, (float)this.spinSpeed);
        this.delayMillis = a.getInteger(R.styleable.ProgressWheel_delayMillis, this.delayMillis);
        if (this.delayMillis < 0) {
            this.delayMillis = 0;
        }
        this.textSize = (int)a.getDimension(R.styleable.ProgressWheel_textSize, (float)this.textSize);
        this.textColor = a.getColor(R.styleable.ProgressWheel_textColor, this.textColor);
        if (a.hasValue(R.styleable.ProgressWheel_text)) {
            this.setText(a.getString(R.styleable.ProgressWheel_text));
        }
        a.recycle();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isSpinning) {
            canvas.drawArc(this.circleBounds, (float)(this.progress - 90), (float)this.barLength, false, this.barPaint);
        } else {
            canvas.drawArc(this.circleBounds, -90.0f, (float)this.progress, false, this.barPaint);
        }
        float textHeight = this.textPaint.descent() - this.textPaint.ascent();
        float verticalTextOffset = textHeight / 2.0f - this.textPaint.descent();
        for (String s : this.splitText) {
            float horizontalTextOffset = this.textPaint.measureText(s) / 2.0f;
            canvas.drawText(s, (float)(this.getWidth() / 2) - horizontalTextOffset, (float)(this.getHeight() / 2) + verticalTextOffset, this.textPaint);
        }
    }

    public boolean isSpinning() {
        return this.isSpinning;
    }

    public void resetCount() {
        this.progress = 0;
        this.setText("0%");
        this.invalidate();
    }

    public void stopSpinning() {
        this.isSpinning = false;
        this.progress = 0;
        this.spinHandler.removeMessages(0);
    }

    public void spin() {
        this.isSpinning = true;
        this.spinHandler.sendEmptyMessage(0);
    }

    public void incrementProgress() {
        this.isSpinning = false;
        ++this.progress;
        if (this.progress > 360) {
            this.progress = 0;
        }
        this.spinHandler.sendEmptyMessage(0);
    }

    public void setProgress(int i) {
        this.isSpinning = false;
        this.progress = i;
        this.spinHandler.sendEmptyMessage(0);
    }

    public void setText(String text) {
        this.text = text;
        this.splitText = this.text.split("\n");
    }

    public int getCircleRadius() {
        return this.circleRadius;
    }

    public void setCircleRadius(int circleRadius) {
        this.circleRadius = circleRadius;
    }

    public int getBarLength() {
        return this.barLength;
    }

    public void setBarLength(int barLength) {
        this.barLength = barLength;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(int barWidth) {
        this.barWidth = barWidth;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public int getPaddingTop() {
        return this.paddingTop;
    }

    public void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
    }

    public int getPaddingBottom() {
        return this.paddingBottom;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public int getPaddingLeft() {
        return this.paddingLeft;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public int getPaddingRight() {
        return this.paddingRight;
    }

    public void setPaddingRight(int paddingRight) {
        this.paddingRight = paddingRight;
    }

    public int getBarColor() {
        return this.barColor;
    }

    public void setBarColor(int barColor) {
        this.barColor = barColor;
    }

    public int getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(int circleColor) {
        this.circleColor = circleColor;
    }

    public int getRimColor() {
        return this.rimColor;
    }

    public void setRimColor(int rimColor) {
        this.rimColor = rimColor;
    }

    public Shader getRimShader() {
        return this.rimPaint.getShader();
    }

    public void setRimShader(Shader shader) {
        this.rimPaint.setShader(shader);
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getSpinSpeed() {
        return this.spinSpeed;
    }

    public void setSpinSpeed(int spinSpeed) {
        this.spinSpeed = spinSpeed;
    }

    public int getRimWidth() {
        return this.rimWidth;
    }

    public void setRimWidth(int rimWidth) {
        this.rimWidth = rimWidth;
    }

    public int getDelayMillis() {
        return this.delayMillis;
    }

    public void setDelayMillis(int delayMillis) {
        this.delayMillis = delayMillis;
    }
}

