/*
 * Decompiled with CFR 0.152.
 */
package com.nicekun.weatherchartlib;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;

public class PollutuinIndicatorPlate
extends View {
    public static final String TAG = PollutuinIndicatorPlate.class.getCanonicalName();
    private static final int GAP_ANGLE = 90;
    private static final int MAX_EXPRESS_STRING_LENGTH = 4;
    private int mCavasWidth;
    private int mCavasHeight;
    private int mFreshLevel1Color = Color.parseColor((String)"#43D23D");
    private int mFreshLevel2Color = Color.parseColor((String)"#D5D300");
    private int mFreshLevel3Color = Color.parseColor((String)"#FFA013");
    private int mFreshLevel4Color = Color.parseColor((String)"#EC4443");
    private int mFreshLevel5Color = Color.parseColor((String)"#9517AC");
    private int mFreshLevel6Color = Color.parseColor((String)"#8F0000");
    private int mLabelColor = Color.parseColor((String)"#333333");
    private int mArcWidth = this.dp2px(16);
    private int mAllPadding = this.dp2px(40);
    private int mExpressMargin = this.dp2px(16);
    private int mIndicatorMargin = this.dp2px(2);
    private float mDiameter;
    private RectF mArcRect = new RectF();
    private Paint mProgressPaint;
    private Paint mLabelPaint;
    private Paint mIndicatorPaint;
    private int mAQI;
    private float mDeltaX;
    private float mDeltaY;

    public PollutuinIndicatorPlate(Context context) {
        super(context);
        this.init(context);
    }

    public PollutuinIndicatorPlate(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PollutuinIndicatorPlate(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mProgressPaint = new Paint();
        this.mProgressPaint.setStrokeWidth((float)this.mArcWidth);
        this.mProgressPaint.setAntiAlias(true);
        this.mProgressPaint.setStyle(Paint.Style.STROKE);
        this.mProgressPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mLabelPaint = new Paint();
        this.mLabelPaint.setAntiAlias(true);
        this.mLabelPaint.setColor(this.mLabelColor);
        this.mIndicatorPaint = new Paint();
        this.mIndicatorPaint.setColor(this.mLabelColor);
        this.mIndicatorPaint.setAntiAlias(true);
        this.mIndicatorPaint.setStyle(Paint.Style.FILL);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minWidthSize = 800;
        int minHeightSize = 800;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.mCavasWidth = widthMode == 0x40000000 ? (widthSize < minWidthSize ? minWidthSize : widthSize) : minWidthSize;
        this.mCavasWidth = minWidthSize;
        this.mCavasHeight = minHeightSize;
        this.mArcRect.top = this.mArcWidth / 2 + this.mAllPadding;
        this.mArcRect.left = this.mArcWidth / 2 + this.mAllPadding;
        this.mArcRect.right = this.mCavasWidth - this.mArcWidth / 2 - this.mAllPadding;
        this.mArcRect.bottom = this.mCavasHeight - this.mArcWidth / 2 - this.mAllPadding;
        this.mDiameter = this.mArcRect.right - this.mArcRect.left;
        double halfAngle = 0.7853981633974483;
        this.mDeltaX = (float)Math.sin(halfAngle) * this.mDiameter / 2.0f;
        this.mDeltaY = (float)Math.cos(halfAngle) * this.mDiameter / 2.0f;
        this.setMeasuredDimension(minWidthSize, minHeightSize);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawColor(-1);
        canvas.save();
        canvas.rotate(135.0f, (float)(this.mCavasWidth / 2), (float)(this.mCavasHeight / 2));
        this.mProgressPaint.setColor(this.mFreshLevel6Color);
        canvas.drawArc(this.mArcRect, 0.0f, 270.0f, false, this.mProgressPaint);
        this.mProgressPaint.setStrokeCap(Paint.Cap.BUTT);
        this.mProgressPaint.setColor(this.mFreshLevel5Color);
        canvas.drawArc(this.mArcRect, 0.0f, 162.0f, false, this.mProgressPaint);
        this.mProgressPaint.setColor(this.mFreshLevel4Color);
        canvas.drawArc(this.mArcRect, 0.0f, 108.0f, false, this.mProgressPaint);
        this.mProgressPaint.setColor(this.mFreshLevel3Color);
        canvas.drawArc(this.mArcRect, 0.0f, 81.0f, false, this.mProgressPaint);
        this.mProgressPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mProgressPaint.setColor(this.mFreshLevel1Color);
        canvas.drawArc(this.mArcRect, 0.0f, 27.0f, false, this.mProgressPaint);
        this.mProgressPaint.setStrokeCap(Paint.Cap.BUTT);
        this.mProgressPaint.setColor(this.mFreshLevel2Color);
        canvas.drawArc(this.mArcRect, 27.0f, 27.0f, false, this.mProgressPaint);
        this.mProgressPaint.setStrokeCap(Paint.Cap.ROUND);
        canvas.restore();
        this.drawTextTips(canvas);
        this.drawIndicator(canvas);
    }

    private void drawIndicator(Canvas canvas) {
        RectF rectF = new RectF();
        rectF.top = 0.0f;
        rectF.left = 0.0f;
        rectF.right = this.mCavasWidth;
        rectF.bottom = this.mCavasHeight;
        int layerCount = canvas.saveLayer(rectF, this.mIndicatorPaint, 31);
        float deltaAngleShouldRotate = (this.mAQI - 250) * 270 / 500;
        canvas.rotate(deltaAngleShouldRotate, (float)(this.mCavasWidth / 2), (float)(this.mCavasHeight / 2));
        float centerX = (this.mArcRect.right + this.mArcRect.left) / 2.0f;
        float centerY = (this.mArcRect.top + this.mArcRect.bottom) / 2.0f;
        Path upArrowPath = new Path();
        upArrowPath.moveTo(centerX, centerY - this.mDiameter / 2.0f - (float)(this.mArcWidth / 2) - (float)this.mIndicatorMargin);
        upArrowPath.lineTo(centerX + (float)(this.mArcWidth / 2), centerY - this.mDiameter / 2.0f - (float)this.mIndicatorMargin - (float)(this.mArcWidth / 2) - (float)this.mArcWidth);
        upArrowPath.lineTo(centerX, centerY - this.mDiameter / 2.0f - (float)(this.mArcWidth / 2) - (float)this.mIndicatorMargin - (float)(this.mArcWidth * 3 / 4));
        upArrowPath.lineTo(centerX - (float)(this.mArcWidth / 2), centerY - this.mDiameter / 2.0f - (float)this.mIndicatorMargin - (float)(this.mArcWidth / 2) - (float)this.mArcWidth);
        upArrowPath.close();
        canvas.drawPath(upArrowPath, this.mIndicatorPaint);
        Path downArrowPath = new Path();
        downArrowPath.moveTo(centerX, centerY - this.mDiameter / 2.0f + (float)(this.mArcWidth / 2) + (float)this.mIndicatorMargin);
        downArrowPath.lineTo(centerX + (float)(this.mArcWidth / 2), centerY - this.mDiameter / 2.0f + (float)(this.mArcWidth / 2) + (float)this.mIndicatorMargin + (float)this.mArcWidth);
        downArrowPath.lineTo(centerX, centerY - this.mDiameter / 2.0f + (float)(this.mArcWidth / 2) + (float)this.mIndicatorMargin + (float)(this.mArcWidth * 3 / 4));
        downArrowPath.lineTo(centerX - (float)(this.mArcWidth / 2), centerY - this.mDiameter / 2.0f + (float)(this.mArcWidth / 2) + (float)this.mIndicatorMargin + (float)this.mArcWidth);
        downArrowPath.close();
        canvas.drawPath(downArrowPath, this.mIndicatorPaint);
        canvas.restoreToCount(layerCount);
    }

    private void drawTextTips(Canvas canvas) {
        float centerX = (this.mArcRect.right + this.mArcRect.left) / 2.0f;
        float centerY = (this.mArcRect.top + this.mArcRect.bottom) / 2.0f;
        String degreeExpress = this.evaluatePollutionDegree(this.mAQI);
        float expressTextSize = (this.mDeltaX * 2.0f - (float)(this.mExpressMargin * 2)) / 4.0f;
        this.mLabelPaint.setTextSize(expressTextSize);
        canvas.drawText(degreeExpress, centerX - this.mDeltaX + (float)this.mExpressMargin, centerY + this.mDeltaY, this.mLabelPaint);
        this.mLabelPaint.setTextSize(expressTextSize * 3.0f / 2.0f);
        Rect rectNumber = this.measureText(this.mLabelPaint, this.mAQI + "");
        canvas.drawText(this.mAQI + "", centerX - (float)(rectNumber.width() / 2), centerY + (float)(rectNumber.height() / 2), this.mLabelPaint);
        this.mLabelPaint.setTextSize(expressTextSize * 2.0f / 3.0f);
        canvas.drawText("AQI", centerX + (float)(rectNumber.width() / 2) + (float)this.sp2px(4), centerY + (float)(rectNumber.height() / 2), this.mLabelPaint);
    }

    private int dp2px(int dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private int sp2px(int spValue) {
        return (int)TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private String evaluatePollutionDegree(int aqi) {
        if (aqi < 50) {
            return "\u4f18";
        }
        if (aqi < 100) {
            return "\u826f";
        }
        if (aqi < 150) {
            return "\u8f7b\u5ea6\u6c61\u67d3";
        }
        if (aqi < 200) {
            return "\u4e2d\u5ea6\u6c61\u67d3";
        }
        if (aqi < 300) {
            return "\u91cd\u5ea6\u6c61\u67d3";
        }
        return "\u4e25\u91cd\u6c61\u67d3";
    }

    private Rect measureText(Paint paint, String text) {
        Rect rect = new Rect();
        paint.getTextBounds(text, 0, text.length(), rect);
        return rect;
    }

    public void setAQI(int AQI) {
        this.mAQI = AQI;
        this.invalidate();
    }

    public int getAQI() {
        return this.mAQI;
    }
}

