/*
 * Decompiled with CFR 0.152.
 */
package com.nicekun.weatherchartlib;

import com.nicekun.weatherchartlib.PollutionDataPoint;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class PollutionTendChartData {
    private List<PollutionDataPoint> mPointList;
    private DataType mDataType;

    private PollutionTendChartData(PollutionTendChartDataBuilder builder) {
        this.mDataType = builder.mDataType;
        this.mPointList = builder.mPointList;
    }

    public List<PollutionDataPoint> getPointList() {
        return this.mPointList;
    }

    public void setPointList(List<PollutionDataPoint> pointList) {
        this.mPointList = pointList;
    }

    public DataType getDataType() {
        return this.mDataType;
    }

    public void setDataType(DataType dataType) {
        this.mDataType = dataType;
    }

    public static class PollutionTendChartDataBuilder {
        List<PollutionDataPoint> mPointList;
        DataType mDataType;
        Date mDate;
        private boolean mIsForcast = false;
        private Integer[] mAqiData;

        public PollutionTendChartDataBuilder(Integer[] aqiData, DataType type) {
            this.mAqiData = aqiData;
            this.mDataType = type;
        }

        public PollutionTendChartData build() {
            if (this.mDataType == null) {
                throw new RuntimeException("datatype should not be null");
            }
            if (this.mAqiData == null || this.mAqiData.length == 0) {
                throw new RuntimeException("aqiData should not be null");
            }
            if (this.mDataType == DataType.HOUR) {
                this.mPointList = this.transferHourData();
            } else if (this.mDataType == DataType.DAY) {
                this.mPointList = this.transferDayData();
            }
            return new PollutionTendChartData(this);
        }

        private List<PollutionDataPoint> transferDayData() {
            ArrayList<PollutionDataPoint> pollutionDataPoints = new ArrayList<PollutionDataPoint>();
            SimpleDateFormat monthDay = new SimpleDateFormat("MM-dd", Locale.getDefault());
            if (this.mIsForcast) {
                Calendar calendar = Calendar.getInstance();
                if (this.mDate != null) {
                    calendar.setTime(this.mDate);
                }
                for (Integer eAqiData : this.mAqiData) {
                    String label = monthDay.format(calendar.getTime());
                    pollutionDataPoints.add(new PollutionDataPoint(eAqiData, label));
                    calendar.add(5, 1);
                }
            } else {
                Calendar calendar = Calendar.getInstance();
                if (this.mDate != null) {
                    calendar.setTime(this.mDate);
                } else {
                    calendar.add(5, -1);
                }
                for (int i = this.mAqiData.length - 1; i >= 0; --i) {
                    Integer eAqiData = this.mAqiData[i];
                    String label = monthDay.format(calendar.getTime());
                    pollutionDataPoints.add(0, new PollutionDataPoint(eAqiData, label));
                    calendar.add(5, -1);
                }
            }
            return pollutionDataPoints;
        }

        private List<PollutionDataPoint> transferHourData() {
            ArrayList<PollutionDataPoint> pollutionDataPoints = new ArrayList<PollutionDataPoint>();
            if (this.mIsForcast) {
                Calendar calendar = Calendar.getInstance();
                int dayCount = 0;
                if (this.mDate != null) {
                    calendar.setTime(this.mDate);
                }
                Integer preHour = null;
                for (Integer eAqiData : this.mAqiData) {
                    int nowHour = calendar.get(11);
                    if (preHour != null && nowHour < preHour) {
                        ++dayCount;
                    }
                    preHour = nowHour;
                    String label = String.valueOf(nowHour) + (dayCount == 0 ? "" : "(+" + dayCount + ")");
                    pollutionDataPoints.add(new PollutionDataPoint(eAqiData, label));
                    calendar.add(11, 1);
                }
            } else {
                Calendar calendar = Calendar.getInstance();
                int dayCount = 0;
                if (this.mDate != null) {
                    calendar.setTime(this.mDate);
                } else {
                    calendar.add(11, -1);
                }
                Integer preHour = null;
                for (int i = this.mAqiData.length - 1; i >= 0; --i) {
                    Integer eAqiData = this.mAqiData[i];
                    int nowHour = calendar.get(11);
                    if (preHour != null && nowHour > preHour) {
                        ++dayCount;
                    }
                    preHour = nowHour;
                    String label = String.valueOf(nowHour) + (dayCount == 0 ? "" : "(-" + dayCount + ")");
                    pollutionDataPoints.add(0, new PollutionDataPoint(eAqiData, label));
                    calendar.add(11, -1);
                }
            }
            return pollutionDataPoints;
        }

        public PollutionTendChartDataBuilder setForcastFirstPointDate(Date time) {
            this.mIsForcast = true;
            this.mDate = time;
            return this;
        }

        public PollutionTendChartDataBuilder setHistoryLastPointDate(Date time) {
            this.mIsForcast = false;
            this.mDate = time;
            return this;
        }
    }

    public static enum DataType {
        HOUR,
        DAY;

    }
}

