/*
 * Decompiled with CFR 0.152.
 */
package com.nicekun.weatherchartlib;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import com.nicekun.weatherchartlib.PollutionDataPoint;
import com.nicekun.weatherchartlib.PollutionTendChartData;
import java.util.List;

public class PollutionTendChart
extends View {
    private static final String TAG = PollutionTendChart.class.getCanonicalName();
    private Paint mAxisPaint;
    private Paint mLabelPaint;
    private Paint mDataLinePaint;
    private Paint mDataDotPaint;
    private int mAxisColor = Color.parseColor((String)"#BABABA");
    private int mDataLineColor = Color.parseColor((String)"#43BDCF");
    private int mGridGrayColor = Color.parseColor((String)"#F1F1F1");
    private int mGridDarkColor = Color.parseColor((String)"#DDDDDD");
    private int mLabelColor = Color.parseColor((String)"#9A9A9A");
    private int mFreshLevel1Color = Color.parseColor((String)"#43D23D");
    private int mFreshLevel2Color = Color.parseColor((String)"#D5D300");
    private int mFreshLevel3Color = Color.parseColor((String)"#FFA013");
    private int mFreshLevel4Color = Color.parseColor((String)"#EC4443");
    private int mFreshLevel5Color = Color.parseColor((String)"#9517AC");
    private int mFreshLevel6Color = Color.parseColor((String)"#8F0000");
    private int mLabelInnerPadding = this.dp2px(2);
    private int mLabelOutterPadding = this.dp2px(8);
    private int mRightPadding = this.dp2px(12);
    private int mTopPadding = this.dp2px(12);
    private int mCavasWidth;
    private int mCavasHeight = this.dp2px(200);
    private int mPerDataDotGapWidth = this.dp2px(27);
    private int mIndicatorBarWidth = this.dp2px(10);
    private final int TRANSLATE_CHART_X_MIN = this.dp2px(20);
    private Integer mTranslateChartX;
    private int mOriginY;
    private int mOriginX;
    private int mDataAreaWidth;
    private int mDataAreaHeight;
    private PollutionTendChartData mData;
    private Float mPreX;
    private Integer mDelta;

    public PollutionTendChart(Context context) {
        super(context);
        this.init(context);
    }

    public PollutionTendChart(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PollutionTendChart(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.setFocusable(true);
        this.mAxisPaint = new Paint();
        this.mAxisPaint.setColor(this.mAxisColor);
        this.mAxisPaint.setStrokeWidth((float)this.dp2px(1));
        this.mAxisPaint.setAntiAlias(true);
        this.mLabelPaint = new Paint();
        this.mLabelPaint.setColor(this.mLabelColor);
        this.mLabelPaint.setTextSize((float)this.sp2px(8));
        this.mLabelPaint.setAntiAlias(true);
        this.mDataLinePaint = new Paint();
        this.mDataLinePaint.setColor(this.mDataLineColor);
        this.mDataLinePaint.setStrokeWidth((float)this.dp2px(2));
        this.mDataLinePaint.setAntiAlias(true);
        this.mDataLinePaint.setStyle(Paint.Style.STROKE);
        this.mDataDotPaint = new Paint();
        this.mDataDotPaint.setColor(this.mDataLineColor);
        this.mDataDotPaint.setAntiAlias(true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minWidthSize = 800;
        int minHeightSize = 600;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.mCavasWidth = widthMode == 0x40000000 ? (widthSize < minWidthSize ? minWidthSize : widthSize) : minWidthSize;
        Rect rect = this.measureText(this.mLabelPaint, "500");
        this.mOriginX = rect.width() + this.mLabelOutterPadding + this.mLabelInnerPadding + this.mIndicatorBarWidth;
        this.mOriginY = this.mCavasHeight - rect.height() - this.mLabelOutterPadding - this.mLabelInnerPadding;
        this.mDataAreaWidth = this.mCavasWidth - this.mRightPadding - rect.width() - this.mLabelOutterPadding - this.mLabelInnerPadding - this.mIndicatorBarWidth;
        this.mDataAreaHeight = this.mCavasHeight - this.mTopPadding - rect.height() - this.mLabelOutterPadding - this.mLabelInnerPadding;
        this.setMeasuredDimension(this.mCavasWidth, this.mCavasHeight);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawColor(-1);
        this.drawAxis(canvas);
        this.drawLineWithData(canvas);
    }

    private void drawLineWithData(Canvas canvas) {
        Integer aqi;
        int dx;
        int i;
        List<PollutionDataPoint> aqiData = this.mData.getPointList();
        PollutionTendChartData.DataType aqiType = this.mData.getDataType();
        int saveCount = canvas.saveLayer((float)this.mOriginX, (float)(this.mOriginY - this.mDataAreaHeight), (float)(this.mOriginX + this.mDataAreaWidth), (float)this.mCavasHeight, this.mAxisPaint, 31);
        if (this.mDelta != null) {
            this.mTranslateChartX = this.mTranslateChartX + this.mDelta;
            if (this.mTranslateChartX > this.TRANSLATE_CHART_X_MIN) {
                this.mTranslateChartX = this.TRANSLATE_CHART_X_MIN;
            } else if (this.mTranslateChartX < this.mDataAreaWidth - this.mPerDataDotGapWidth * aqiData.size()) {
                this.mTranslateChartX = this.mDataAreaWidth - this.mPerDataDotGapWidth * aqiData.size();
            }
        } else if (this.mTranslateChartX == null) {
            this.mTranslateChartX = this.mDataAreaWidth - this.mPerDataDotGapWidth * aqiData.size();
        }
        canvas.translate((float)this.mTranslateChartX.intValue(), 0.0f);
        this.mDelta = null;
        canvas.drawLine((float)(this.mOriginX - this.TRANSLATE_CHART_X_MIN), (float)this.mOriginY, (float)(this.mOriginX + this.mPerDataDotGapWidth * aqiData.size()), (float)this.mOriginY, this.mAxisPaint);
        Path dataPath = new Path();
        boolean exitsBreakPoint = true;
        for (i = 0; i < aqiData.size(); ++i) {
            dx = this.mOriginX + i * this.mPerDataDotGapWidth;
            aqi = aqiData.get(i).getAQI();
            if (aqi == null) {
                exitsBreakPoint = true;
                continue;
            }
            int dy = this.mOriginY - this.mDataAreaHeight * aqiData.get(i).getAQI() / 500;
            if (exitsBreakPoint) {
                dataPath.moveTo((float)dx, (float)dy);
            } else {
                dataPath.lineTo((float)dx, (float)dy);
            }
            exitsBreakPoint = false;
        }
        canvas.drawPath(dataPath, this.mDataLinePaint);
        for (i = 0; i < aqiData.size(); ++i) {
            dx = this.mOriginX + i * this.mPerDataDotGapWidth;
            aqi = aqiData.get(i).getAQI();
            if (i % 5 == 0) {
                this.mAxisPaint.setColor(this.mGridDarkColor);
                canvas.drawLine((float)dx, (float)this.mOriginY, (float)dx, (float)(this.mOriginY - this.mDataAreaHeight), this.mAxisPaint);
                this.mAxisPaint.setColor(this.mAxisColor);
                String formatTimeExpress = aqiData.get(i).getLabel();
                Rect timeRect = this.measureText(this.mLabelPaint, formatTimeExpress);
                canvas.drawText(formatTimeExpress, (float)(dx - timeRect.width() / 2), (float)(this.mOriginY + this.mLabelInnerPadding + timeRect.height()), this.mLabelPaint);
            }
            if (aqi == null) continue;
            int dy = this.mOriginY - this.mDataAreaHeight * aqi / 500;
            canvas.drawCircle((float)dx, (float)dy, 8.0f, this.mDataDotPaint);
            this.mDataDotPaint.setColor(-1);
            canvas.drawCircle((float)dx, (float)dy, 6.0f, this.mDataDotPaint);
            this.mDataDotPaint.setColor(this.mDataLineColor);
        }
        canvas.restoreToCount(saveCount);
    }

    private void drawAxis(Canvas canvas) {
        this.mAxisPaint.setStrokeWidth((float)this.mIndicatorBarWidth);
        this.mAxisPaint.setColor(this.mFreshLevel1Color);
        canvas.save();
        canvas.translate((float)(-this.mIndicatorBarWidth / 2), 0.0f);
        canvas.drawLine((float)this.mOriginX, (float)this.mOriginY, (float)this.mOriginX, (float)(this.mOriginY - this.mDataAreaHeight * 50 / 500), this.mAxisPaint);
        this.mAxisPaint.setColor(this.mFreshLevel2Color);
        canvas.drawLine((float)this.mOriginX, (float)(this.mOriginY - this.mDataAreaHeight * 50 / 500), (float)this.mOriginX, (float)(this.mOriginY - this.mDataAreaHeight * 100 / 500), this.mAxisPaint);
        this.mAxisPaint.setColor(this.mFreshLevel3Color);
        canvas.drawLine((float)this.mOriginX, (float)(this.mOriginY - this.mDataAreaHeight * 100 / 500), (float)this.mOriginX, (float)(this.mOriginY - this.mDataAreaHeight * 150 / 500), this.mAxisPaint);
        this.mAxisPaint.setColor(this.mFreshLevel4Color);
        canvas.drawLine((float)this.mOriginX, (float)(this.mOriginY - this.mDataAreaHeight * 150 / 500), (float)this.mOriginX, (float)(this.mOriginY - this.mDataAreaHeight * 200 / 500), this.mAxisPaint);
        this.mAxisPaint.setColor(this.mFreshLevel5Color);
        canvas.drawLine((float)this.mOriginX, (float)(this.mOriginY - this.mDataAreaHeight * 200 / 500), (float)this.mOriginX, (float)(this.mOriginY - this.mDataAreaHeight * 300 / 500), this.mAxisPaint);
        this.mAxisPaint.setColor(this.mFreshLevel6Color);
        canvas.drawLine((float)this.mOriginX, (float)(this.mOriginY - this.mDataAreaHeight * 300 / 500), (float)this.mOriginX, (float)(this.mOriginY - this.mDataAreaHeight), this.mAxisPaint);
        Rect rect50 = this.measureText(this.mLabelPaint, "50");
        canvas.drawText("50", (float)(this.mOriginX - rect50.width() - this.mLabelInnerPadding - this.mIndicatorBarWidth), (float)(this.mOriginY - this.mDataAreaHeight * 50 / 500 + rect50.height() / 2), this.mLabelPaint);
        canvas.drawText("100", (float)(this.mOriginX - this.measureText(this.mLabelPaint, "100").width() - this.mLabelInnerPadding - this.mIndicatorBarWidth), (float)(this.mOriginY - this.mDataAreaHeight * 100 / 500 + rect50.height() / 2), this.mLabelPaint);
        canvas.drawText("150", (float)(this.mOriginX - this.measureText(this.mLabelPaint, "150").width() - this.mLabelInnerPadding - this.mIndicatorBarWidth), (float)(this.mOriginY - this.mDataAreaHeight * 150 / 500 + rect50.height() / 2), this.mLabelPaint);
        canvas.drawText("200", (float)(this.mOriginX - this.measureText(this.mLabelPaint, "200").width() - this.mLabelInnerPadding - this.mIndicatorBarWidth), (float)(this.mOriginY - this.mDataAreaHeight * 200 / 500 + rect50.height() / 2), this.mLabelPaint);
        canvas.drawText("300", (float)(this.mOriginX - this.measureText(this.mLabelPaint, "300").width() - this.mLabelInnerPadding - this.mIndicatorBarWidth), (float)(this.mOriginY - this.mDataAreaHeight * 300 / 500 + rect50.height() / 2), this.mLabelPaint);
        canvas.drawText("500", (float)(this.mOriginX - this.measureText(this.mLabelPaint, "500").width() - this.mLabelInnerPadding - this.mIndicatorBarWidth), (float)(this.mOriginY - this.mDataAreaHeight + rect50.height() / 2), this.mLabelPaint);
        canvas.restore();
        this.mAxisPaint.setColor(this.mGridGrayColor);
        canvas.drawRect((float)this.mOriginX, (float)(this.mOriginY - this.mDataAreaHeight * 100 / 500), (float)(this.mOriginX + this.mDataAreaWidth), (float)(this.mOriginY - this.mDataAreaHeight * 50 / 500), this.mAxisPaint);
        canvas.drawRect((float)this.mOriginX, (float)(this.mOriginY - this.mDataAreaHeight * 200 / 500), (float)(this.mOriginX + this.mDataAreaWidth), (float)(this.mOriginY - this.mDataAreaHeight * 150 / 500), this.mAxisPaint);
        canvas.drawRect((float)this.mOriginX, (float)(this.mOriginY - this.mDataAreaHeight), (float)(this.mOriginX + this.mDataAreaWidth), (float)(this.mOriginY - this.mDataAreaHeight * 300 / 500), this.mAxisPaint);
        this.mAxisPaint.setColor(this.mAxisColor);
        this.mAxisPaint.setStrokeWidth((float)this.dp2px(1));
    }

    private Rect measureText(Paint paint, String text) {
        Rect rect = new Rect();
        paint.getTextBounds(text, 0, text.length(), rect);
        return rect;
    }

    public void setData(PollutionTendChartData data) {
        this.mData = data;
        this.invalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                float x = event.getX();
                float y = event.getY();
                if (x > (float)this.mOriginX && x < (float)(this.mOriginX + this.mDataAreaWidth) && y > (float)(this.mOriginY - this.mDataAreaHeight) && y < (float)this.mOriginY) {
                    this.mPreX = Float.valueOf(x);
                    return true;
                }
                return false;
            }
            case 2: {
                if (this.mPreX == null) break;
                float thisX = event.getX();
                this.mDelta = (int)(thisX - this.mPreX.floatValue());
                this.mPreX = Float.valueOf(thisX);
                this.invalidate();
                break;
            }
            case 1: 
            case 3: {
                this.mPreX = null;
            }
        }
        return true;
    }

    private int dp2px(int dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private int sp2px(int spValue) {
        return (int)TypedValue.applyDimension((int)2, (float)spValue, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }
}

