/*
 * Decompiled with CFR 0.152.
 */
package com.nicekun.uczananimation;

import android.graphics.Bitmap;
import com.nicekun.uczananimation.UCZanAnimationResource;
import com.nicekun.uczananimation.UCZanSprite;
import java.util.ArrayList;
import java.util.List;

public class UCZanSpriteManager {
    private UCZanAnimationResource mResource;

    public UCZanSpriteManager(UCZanAnimationResource resource) {
        this.mResource = resource;
    }

    public List<UCZanSprite> obtain(int count, SpriteType normal) {
        ArrayList<UCZanSprite> sprites = new ArrayList<UCZanSprite>();
        for (int i = 0; i < count; ++i) {
            UCZanSprite sprite = this.obtainSingle(normal);
            if (sprite == null) continue;
            sprites.add(sprite);
        }
        return sprites;
    }

    public UCZanSprite obtainSingle(SpriteType normal) {
        Bitmap randomBitmap = null;
        switch (normal) {
            case NORMAL: {
                randomBitmap = this.mResource.getRandomBitmap();
                break;
            }
            case SURPRISE: {
                randomBitmap = this.mResource.getRandomBitmap(true);
            }
        }
        if (randomBitmap != null) {
            return new UCZanSprite("actor-" + (int)(Math.random() * 100.0), randomBitmap);
        }
        return null;
    }

    public static enum SpriteType {
        NORMAL,
        SURPRISE;

    }
}

