/*
 * Decompiled with CFR 0.152.
 */
package com.nicekun.uczananimation;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.nicekun.uczananimation.UCZanAnimationFunction;

public class UCZanSprite {
    private Bitmap pic;
    private String name;
    private int alpha;
    private int leftPos;
    private int topPos;
    private float relX;
    private float relY;
    private int invalidCount;
    private UCZanAnimationFunction mUCZanAnimationFunction;

    public UCZanSprite(String name, Bitmap pic) {
        this.name = name;
        this.pic = pic;
        this.alpha = 255;
    }

    public Bitmap getPic() {
        return this.pic;
    }

    public void setPic(Bitmap pic) {
        this.pic = pic;
    }

    public int getLeftPos() {
        return this.leftPos;
    }

    public int getTopPos() {
        return this.topPos;
    }

    public float getRelX() {
        return this.relX;
    }

    public float getRelY() {
        return this.relY;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setPostion(int leftPos, int topPos) {
        this.leftPos = leftPos;
        this.topPos = topPos;
    }

    public void setGravity(float relX, float relY) {
        if (relX < 0.0f || relX > 1.0f || relY < 0.0f || relY > 1.0f) {
            return;
        }
        this.relX = relX;
        this.relY = relY;
    }

    public void setGravity(Gravity gravity) {
        this.setGravity(gravity.relX, gravity.relY);
    }

    public void draw(Canvas canvas, Paint paint) {
        ++this.invalidCount;
        this.doMove(this.invalidCount);
        int alphaPre = paint.getAlpha();
        paint.setAlpha(this.alpha);
        canvas.drawBitmap(this.pic, (float)this.leftPos - (float)this.pic.getWidth() * this.relX, (float)this.topPos - (float)this.pic.getHeight() * this.relY, paint);
        paint.setAlpha(alphaPre);
    }

    private void doMove(int invalidCount) {
        if (this.mUCZanAnimationFunction != null) {
            this.leftPos += this.mUCZanAnimationFunction.moveDeltaX(invalidCount);
            this.topPos += this.mUCZanAnimationFunction.moveDeltaY(invalidCount);
            this.alpha -= this.mUCZanAnimationFunction.moveAlpha(invalidCount);
            if (this.alpha < 0) {
                this.alpha = 0;
            } else if (this.alpha > 255) {
                this.alpha = 255;
            }
        }
    }

    public void setFunction(UCZanAnimationFunction function) {
        this.mUCZanAnimationFunction = function;
    }

    public Rect getRect() {
        return new Rect(this.leftPos, this.topPos, this.leftPos + this.pic.getWidth(), this.topPos + this.pic.getHeight());
    }

    public static enum Gravity {
        CENTER(0.5f, 0.5f),
        NE(1.0f, 0.0f),
        N(0.5f, 0.0f),
        NW(0.0f, 0.0f),
        E(1.0f, 0.5f),
        W(0.0f, 0.5f),
        S(0.5f, 1.0f),
        SW(0.0f, 1.0f),
        SE(1.0f, 1.0f);

        private float relX;
        private float relY;

        private Gravity(float relX, float relY) {
            this.relX = relX;
            this.relY = relY;
        }

        public float getRelX() {
            return this.relX;
        }

        public float getRelY() {
            return this.relY;
        }
    }
}

